# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.antirobot import resources as ar_resources


class BuildAntirobotBundle(CommonBuildTask, nanny.ReleaseToNannyTask):
    """
        Build antirobot bundle
    """
    type = 'BUILD_ANTIROBOT_BUNDLE'
    TARGET_RESOURCES = (
        (resource_types.ANTIROBOT_DAEMON_EXECUTABLE, 'antirobot/daemon/antirobot_daemon'),
        (resource_types.ANTIROBOT_EVLOGDUMP_EXECUTABLE, 'antirobot/tools/evlogdump/antirobot_evlogdump'),
        (ar_resources.ANTIROBOT_GENCFG_EXECUTABLE, 'antirobot/scripts/gencfg/antirobot_gencfg'),
        (ar_resources.JSON_CONFIG_CHECKER_EXECUTABLE, 'antirobot/tools/json_config_checker/json_config_checker'),
    )

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

__Task__ = BuildAntirobotBundle
