# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox import common
import sandbox.common.types.client as ctc


class AntirobotCgroupTestingTask(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.LINUX_XENIAL

    def on_execute(self):
        cg = common.os.CGroup("my_group")
        cg.cpu["cfs_quota_us"] = "108800"
        cg.cpu["cfs_period_us"] = "10000"
        popen = sp.Popen(['sleep', '60'], preexec_fn=cg.set_current)
        popen.wait()
