from __future__ import print_function
import json
import logging
import os
import urllib

from sandbox import sdk2
from sandbox.sandboxsdk import ssh
from sandbox.sandboxsdk.svn import Arcadia


DEFAULT_ARCADIA_PATH = '/antirobot/config'

ARCADIA_KEY_OWNER = 'ANTIROBOT'
ARCADIA_KEY_NAME = 'sec-01et7d3vg6y85r3jzg9kqxk121[id_rsa]'
ARCADIA_USER = 'robot-ne-robot'

CONFIG = {
    'market': [
        'https://proxy.sandbox.yandex-team.ru/last/MARKET_ANTIROBOT_ROUTES_DESKTOP',
        'https://proxy.sandbox.yandex-team.ru/last/MARKET_ANTIROBOT_ROUTES_TOUCH',
    ],
    'marketpartner': [
        'https://proxy.sandbox.yandex-team.ru/last/MARKET_ANTIROBOT_ROUTES_PARTNER',
    ],
    'marketred': [
        'https://proxy.sandbox.yandex-team.ru/last/MARKET_ANTIROBOT_ROUTES_RED_DESKTOP',
    ],
    'marketblue': [
        'https://proxy.sandbox.yandex-team.ru/last/MARKET_ANTIROBOT_ROUTES_BLUE_DESKTOP',
        'https://proxy.sandbox.yandex-team.ru/last/MARKET_ANTIROBOT_ROUTES_BLUE_TOUCH',
    ],
}


def get_rules_from_url(url):
    lines = urllib.urlopen(url).read().split('\n')
    rules = []
    for line in lines:
        parts = line.split()
        rule = {}
        if len(parts) == 2:
            rule['path'] = parts[0]
            rule['req_type'] = parts[1]
            # CAPTCHA-1537, temporary crutch
            if rule['req_type'] == "main":
                rule['req_type'] = "analytical"
        elif len(parts) == 3:
            rule['path'] = parts[0]
            rule['cgi'] = parts[1]
            rule['req_type'] = parts[2]
            # CAPTCHA-1537, temporary crutch
            if rule['req_type'] == "main":
                rule['req_type'] = "analytical"
        else:
            assert len(parts) in (2, 3), "Should contain 2 or 3 fields. Line: " + line

        rules.append(rule)
    return rules


class AntirobotConvertMarket2ServiceConfigTask(sdk2.Task):
    """Task to convert markets config to serice_config.json"""

    def get_config_path(self):
        return str(self.path("config/"))

    def on_execute(self):

        logging.info(self.get_config_path())
        service_config_file = os.path.join(self.get_config_path(), 'service_config.json')

        logging.info("Checking out service_config.json")
        Arcadia.checkout('arcadia:/arc/trunk/arcadia{}'.format(DEFAULT_ARCADIA_PATH), self.get_config_path())

        with open(service_config_file) as f:
            service_config = json.load(f)

        for service, urls in CONFIG.iteritems():
            rules = []
            for url in urls:
                logging.info('Retrieve rules for %s from url', service, url)
                rules.extend(get_rules_from_url(url))

            for i, config in enumerate(service_config):
                if config['service'] == service:
                    index = i
                    json_config = config
                    break

            json_config['re_queries'] = rules
            service_config[index] = json_config

        with open(service_config_file, 'w') as f:
            print(json.dumps(service_config, indent=4, sort_keys=True, separators=(',', ': ')), file=f)

        diff = Arcadia.diff(service_config_file)
        if diff:
            logging.info(diff)
            logging.info('committing to Arcadia...')
            with ssh.Key(self, key_owner=ARCADIA_KEY_OWNER, key_name=ARCADIA_KEY_NAME):
                commit_output = Arcadia.commit(
                    self.get_config_path(),
                    'update comfig for {}'.format(service),
                    user=ARCADIA_USER
                    )
                logging.info(commit_output)
                logging.info('successfully committed')
        else:
            logging.info('nothing changed')
