from sandbox import sdk2
import requests
import StringIO
import subprocess
import sys


class AntirobotResourceDiff(sdk2.Resource):
    any_arch = True
    executable = False
    releasable = False


def compare_resources(task, old_id, new_id):
    import sandboxsdk.svn
    sys.path.append(sandboxsdk.svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/contrib/deprecated/python/diff2html"))
    import diff2html

    old = requests.get("https://proxy.sandbox.yandex-team.ru/{}".format(old_id)).text
    new = requests.get("https://proxy.sandbox.yandex-team.ru/{}".format(new_id)).text

    with open('old.json', 'w') as f:
        f.write(old)

    with open('new.json', 'w') as f:
        f.write(new)

    p = subprocess.Popen(
        [
            "diff", "--unified=5000000",
            "old.json",
            "new.json"
        ],
        stdout=subprocess.PIPE, stderr=subprocess.PIPE,
    )
    out, err = p.communicate()

    diff_file_name = "diff_{}_{}.html".format(old_id, new_id)
    with open(diff_file_name, 'w') as diff_file:
        if p.returncode == 1:
            input = StringIO.StringIO(out)
            diff2html.parse_input(input, diff_file, "diff.txt", None, None, None)
        elif p.returncode == 0:
            diff_file.write('NO DIFF')
        else:
            assert p.returncode in (0, 1), "out: {}\n\nerr: {}".format(out, err)

    resource = AntirobotResourceDiff(task, '', diff_file_name, ttl='inf')
    sdk2.ResourceData(resource).ready()
    return resource


def get_resource_info(resource):
    return {
        "id": resource.id,
        "type": str(resource.type),
        "path": str(resource.path),
        "description": resource.description,
        "owner": resource.owner,
        "task_id": resource.task_id,
        "state": resource.state,
        "arch": resource.arch,
        "created": str(resource.created),
        # "accessed": resource.accessed,
        # "updated": resource.updated,
        # "expires": resource.expires,
        "size": resource.size,
        "md5": resource.md5,
        "rights": resource.rights,
        "url": resource.url,
        "http_proxy": resource.http_proxy,
    }


def compare_multiple_resources(task, old_resources, new_resource, serializable=False):
    serizalization_transform = lambda resource: resource if not serializable else get_resource_info(resource)

    diffs = []
    for resource_to_compare in old_resources:
        diff_resource = compare_resources(task, resource_to_compare.id, new_resource.id)
        diffs.append((serizalization_transform(resource_to_compare),
                      serizalization_transform(new_resource),
                      serizalization_transform(diff_resource)))

    return diffs
