# -*- coding: utf-8 -*-

from sandbox.projects.antirobot.LoadTestingV3 import (
    AntirobotTankLoadTestingTask,
    MOCK_BINARIES_DEFAULT_RESOURCE,
    PHANTOM_AMMO_DEFAULT_RESOURCE,
    TANK_VIRTUALENV_DEFAULT_RESOURCE,
    PHANTOM_BINARY_DEFAULT_RESOURCE,
    TANK_PATCH_DEFAULT_RESOURCE,
    UNISTAT_PROXY_DEFAULT_RESOURCE,
)
from sandbox import sdk2
from sandbox import common
import sandbox.common.types.task as ctt
from sandbox.projects.resource_types import ANTIROBOT_BUNDLE
from sandbox.projects.tank.load_resources.resources import (
    YANDEX_TANK_VIRTUALENV_19,
    PHANTOM_EXECUTABLE,
)


class AntirobotTankLoadTestingTaskBackCompatibility(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        antirobot_bundle = sdk2.parameters.Resource(
            'Antirobot binaries',
            resource_type=ANTIROBOT_BUNDLE,
            required=True,
        )

        mock_binaries = sdk2.parameters.Resource(
            'Captcha and wizard mocks binaries',
            default_value=MOCK_BINARIES_DEFAULT_RESOURCE,
            required=True,
        )

        ammo_file = sdk2.parameters.Resource(
            'Phantom ammo file',
            default_value=PHANTOM_AMMO_DEFAULT_RESOURCE,
            required=True,
        )

        tank_virtualenv = sdk2.parameters.Resource(
            'Tank virtualenv archive',
            resource_type=YANDEX_TANK_VIRTUALENV_19,
            default_value=TANK_VIRTUALENV_DEFAULT_RESOURCE,
            required=True,
        )

        phantom_binary = sdk2.parameters.Resource(
            'Phantom binary',
            resource_type=PHANTOM_EXECUTABLE,
            default_value=PHANTOM_BINARY_DEFAULT_RESOURCE,
            required=True,
        )

        tank_patch = sdk2.parameters.Resource(
            'Tank patch',
            default_value=TANK_PATCH_DEFAULT_RESOURCE,
            required=True,
        )

        unistat_proxy_binary = sdk2.parameters.Resource(
            'Unistat proxy binary',
            default_value=UNISTAT_PROXY_DEFAULT_RESOURCE,
            required=True,
        )

        nanny_oauth_token_vault_owner = sdk2.parameters.String(
            'Vault owner of Nanny OAuth token',
            default_value=''
        )

        nanny_oauth_token_vault_name = sdk2.parameters.String(
            'Vault item containing Nanny OAuth token',
            required=True,
            default_value='nanny-oauth-token'
        )

    def _create_subtasks(self):
        subtasks = []
        for i in range(2):
            subtask = AntirobotTankLoadTestingTask(
                self,
                owner=self.owner,
                description="Child of AntirobotTankLoadTestingTaskBackCompatibility task {}".format(self.id),
                priority=self.Parameters.priority,
                antirobot_bundle=self.Parameters.antirobot_bundle,
                prod_antirobot=True,
                shoot_to_prod=bool(i),
                nanny_oauth_token_vault_owner=self.Parameters.nanny_oauth_token_vault_owner,
                nanny_oauth_token_vault_name=self.Parameters.nanny_oauth_token_vault_name,
                mock_binaries=self.Parameters.mock_binaries,
                ammo_file=self.Parameters.ammo_file,
                tank_virtualenv=self.Parameters.tank_virtualenv,
                phantom_binary=self.Parameters.phantom_binary,
                tank_patch=self.Parameters.tank_patch,
                unistat_proxy_binary=self.Parameters.unistat_proxy_binary,
            )
            subtasks.append(subtask.enqueue().id)
        return subtasks

    def on_execute(self):
        with self.memoize_stage.create_children:
            subtasks = self._create_subtasks()
            self.Context.subtask_ids = subtasks

            raise sdk2.WaitTask(subtasks, set(common.utils.chain(ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)),
                                wait_all=True)
        subtasks = list(self.find(id=self.Context.subtask_ids))

        failed = [subtask for subtask in subtasks if subtask.status not in ctt.Status.Group.SUCCEED]
        if failed:
            raise common.errors.TaskFailure("Failed subtasks: {}".format(failed))
