import json
import os
import tarfile

from sandbox import sdk2
from sandbox.sdk2.helpers.process import subprocess as sp
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.projects.resource_types import ANTIROBOT_BUNDLE, ANTIROBOT_FORMULAS


DEFAULT_SVN_REPO = 'svn+ssh://arcadia.yandex.ru/arc/trunk'
SERVICES = ['other', 'web', 'xml_c', 'click', 'img', 'news', 'yaca', 'blogs', 'hiliter', 'market', 'rca', 'video', 'avia',
            'slovari', 'tech', 'auto', 'rabota', 'realty', 'travel', 'music', 'kinopoisk', 'autoru', 'bus', 'webmaster',
            'wordstat', 'maps', 'pogoda', 'sprav', 'zen', 'afisha', 'collections', 'iznanka', 'taxi', 'kpapi', 'suggest',
            'marketpartner', 'marketapi', 'marketblue', 'publicugc', 'znatoki', 'local', 'translate', 'marketred', 'uslugi',
            'searchapp', 'morda', 'yaru', 'tutor', 'messenger', 'avatars', 'voice', 'eda', 'turbo', 'turbosite',
            'marketapi_white', 'marketapi_blue', 'marketfapi_white', 'marketfapi_blue', 'health', 'plus', 'classified',
            "cloud", "advert",
            ]


def RunJsonConfigChecker(jsonData):
    workingDir = 'antirobot'
    jsonCheckerBinName = 'json_config_checker'
    jsonRegExpFileName = 'service_identifier.json'
    jsonFileName = 'service_config.json'

    # NOTE: It will find the latest created resource, not the latest released (probably not the production one)
    antirobotBundleResourceList = sdk2.Resource.find(ANTIROBOT_BUNDLE, attrs={'branch': 'antirobot/ps44'}).order(-sdk2.Resource.id)
    assert antirobotBundleResourceList.first() is not None, 'There is no released ANTIROBOT_BUNDLE resource'
    antirobotBundleResource = antirobotBundleResourceList.first()
    with tarfile.open(str(sdk2.ResourceData(antirobotBundleResource).path)) as tar:
        tar.extractall(workingDir)

    with open(os.path.join(workingDir, jsonFileName), 'w') as jsonFile:
        json.dump(jsonData, jsonFile, indent=4)

    Arcadia.export('%s/arcadia/antirobot/config/%s' % (DEFAULT_SVN_REPO, jsonRegExpFileName), os.path.join(workingDir, jsonRegExpFileName))

    antirobotFormulasResourceList = sdk2.Resource.find(ANTIROBOT_FORMULAS, attrs={'released': 'stable'}).order(-sdk2.Resource.id)
    assert antirobotFormulasResourceList, 'There is no released ANTIROBOT_FORMULAS resource'
    antirobotFormulasResource = antirobotFormulasResourceList.first()
    with tarfile.open(str(sdk2.ResourceData(antirobotFormulasResource).path)) as tar:
        tar.extractall()

    processDescription = [
        os.path.join(workingDir, jsonCheckerBinName),
        "--service-config", os.path.join(workingDir, jsonFileName),
        "--service-identifier", os.path.join(workingDir, jsonRegExpFileName),
    ]
    process = sp.Popen(processDescription, stdout=sp.PIPE, stderr=sp.PIPE)
    stdout, stderr = process.communicate()
    assert process.returncode == 0, "Check failed\n\nstdout: {}\n\nstderr: {}".format(stdout, stderr)


def FindLastCorrectResourse(service):
    serviceConfigResourceList = sdk2.Resource.find(resource_type=sdk2.Resource['ANTIROBOT_SERVICE_JSON_FILE_RESOURCE'],
                                                   attrs={'service': service}, state='READY').order(-sdk2.Resource.id)

    limit = 100
    offset = 0
    resourceList = list(serviceConfigResourceList.offset(offset).limit(limit))
    while len(resourceList):
        for serviceConfigResource in resourceList:
            if isinstance(sdk2.Task[serviceConfigResource.task_id], sdk2.Task['ANTIROBOT_VALIDATION_SERVICE_JSON_FILE']):
                return serviceConfigResource
        offset += limit
        resourceList = serviceConfigResourceList.offset(offset).limit(limit)

    return None


def UnitJsonConfigData():
    jsonData = []
    for service in SERVICES:
        correctServiceConfigResource = FindLastCorrectResourse(service)
        assert correctServiceConfigResource is not None, 'There is no correct ANTIROBOT_SERVICE_JSON_FILE_RESOURCE ' \
                                                         'resource with attribute service = %s' % service

        with open(str(sdk2.ResourceData(correctServiceConfigResource).path), 'r') as jsonFile:
            jsonData.append(json.load(jsonFile))
    return jsonData

ANTIROBOT_TEAM = {'toshchakov', 'ashagarov', 'bikulov', 'ulyanov', 'tyamgin', 'rzhikharevich'}

SERVICE_LOGINS = {
    'other': ANTIROBOT_TEAM,
    'web': ANTIROBOT_TEAM,
    'xml_c': ANTIROBOT_TEAM,
    'click': ANTIROBOT_TEAM,
    'img': ANTIROBOT_TEAM,
    'news': ANTIROBOT_TEAM,
    'yaca': ANTIROBOT_TEAM,
    'blogs': ANTIROBOT_TEAM,
    'hiliter': ANTIROBOT_TEAM,
    'market': ANTIROBOT_TEAM,
    'rca': ANTIROBOT_TEAM,
    'video': ANTIROBOT_TEAM,
    'avia': ANTIROBOT_TEAM,
    'slovari': ANTIROBOT_TEAM,
    'tech': ANTIROBOT_TEAM,
    'auto': ANTIROBOT_TEAM,
    'rabota': ANTIROBOT_TEAM,
    'realty': ANTIROBOT_TEAM | {"ibiryulin", "dshtan", "spooner"},
    'travel': ANTIROBOT_TEAM,
    'music': ANTIROBOT_TEAM | {"paulus"},
    'kinopoisk': ANTIROBOT_TEAM | {"gibzer", "vyacheslav", "coldmind", "chrono", "sergeyv"},
    'autoru': ANTIROBOT_TEAM,
    'bus': ANTIROBOT_TEAM,
    'webmaster': ANTIROBOT_TEAM,
    'wordstat': ANTIROBOT_TEAM,
    'maps': ANTIROBOT_TEAM,
    'pogoda': ANTIROBOT_TEAM,
    'sprav': ANTIROBOT_TEAM,
    'zen': ANTIROBOT_TEAM,
    'afisha': ANTIROBOT_TEAM,
    'collections': ANTIROBOT_TEAM,
    'iznanka': ANTIROBOT_TEAM,
    'taxi': ANTIROBOT_TEAM,
    'kpapi': ANTIROBOT_TEAM,
    'suggest': ANTIROBOT_TEAM,
    'marketpartner': ANTIROBOT_TEAM,
    'marketapi': ANTIROBOT_TEAM,
    'marketblue': ANTIROBOT_TEAM,
    'publicugc': ANTIROBOT_TEAM,
    'znatoki': ANTIROBOT_TEAM,
    'local': ANTIROBOT_TEAM,
    'translate': ANTIROBOT_TEAM,
    'marketred': ANTIROBOT_TEAM,
    'uslugi': ANTIROBOT_TEAM | {"osfavstov", "diplay", "antonzakharov", "ilyaifanov", "aleksey-titov", "kate-zabelova", "ap-lunkin", "zhshishkin", "muzich", "sukhoi", "niksorokin"},
    'searchapp': ANTIROBOT_TEAM,
    'morda': ANTIROBOT_TEAM,
    'yaru': ANTIROBOT_TEAM,
    'tutor': ANTIROBOT_TEAM,
    'messenger': ANTIROBOT_TEAM | {"librarian", "yamilov", "jkennedy", "chmerev", "thorfinn", "manokk", "jkee"},
    'avatars': ANTIROBOT_TEAM,
    'voice': ANTIROBOT_TEAM,
    'eda': ANTIROBOT_TEAM,
    'turbo': ANTIROBOT_TEAM,
    'turbosite': ANTIROBOT_TEAM,
    'marketapi_white': ANTIROBOT_TEAM,
    'marketapi_blue': ANTIROBOT_TEAM,
    'marketfapi_white': ANTIROBOT_TEAM,
    'marketfapi_blue': ANTIROBOT_TEAM,
    'health': ANTIROBOT_TEAM,
    'plus': ANTIROBOT_TEAM,
    'classified': ANTIROBOT_TEAM,
    'cloud': ANTIROBOT_TEAM,
    'advert': ANTIROBOT_TEAM,
}
