import json

from sandbox import sdk2
from sandbox.projects.antirobot.MergeJsonConfigFiles import RunJsonConfigChecker, UnitJsonConfigData, ANTIROBOT_TEAM
from sandbox.projects.antirobot.DiffResources import compare_multiple_resources
from sandbox.projects.common.nanny import nanny


class AntirobotJsonConfigFileResource(sdk2.Resource):
    """Antirobot config file"""
    any_arch = True
    executable = False
    releasable = True
    releasers = list(ANTIROBOT_TEAM)


class AntirobotMergeJsonConfigFilesTask(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Task to merge all service configs to a single json file"""

    def on_execute(self):
        json_data = UnitJsonConfigData()
        RunJsonConfigChecker(json_data)

        json_file_path = 'service_config.json'

        with open(json_file_path, 'w') as json_file:
            json.dump(json_data, json_file, indent=4)

        resources_to_compare = list(sdk2.Resource.find(type=AntirobotJsonConfigFileResource, state='READY').limit(10))

        resource = AntirobotJsonConfigFileResource(self, '', json_file_path, ttl='inf')
        sdk2.ResourceData(resource).ready()

        self.Context.diffs = compare_multiple_resources(self, resources_to_compare, resource, serializable=True)

    @sdk2.header()
    def header(self):
        if 'diffs' not in self.Context or self.Context.diffs is None or len(self.Context.diffs) == 0:
            return None

        html = ''
        for diff in self.Context.diffs:
            diff_resource_url = diff[2]['http_proxy']
            old_resource_id = diff[0]['id']
            new_resource_id = diff[1]['id']
            html += '<a href="{}">Compare {} and {}</a>'.format(diff_resource_url, old_resource_id, new_resource_id)
            html += '<br/>'
            html += '\n'
        return html
