# -*- coding: utf-8 -*-

import datetime
import os
import urllib

from sandbox import sdk2
import sandbox.sandboxsdk.environments as environments


class CalculateRobotsDifferenceTask(sdk2.Task):
    """
    Calculate most active new robots for a given time
    """

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        environments = [
            environments.PipEnvironment('yql'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        from yql.api.v1.client import YqlClient
        from yql.client.parameter_value_builder import YqlParameterValueBuilder as ValueBuilder
        import yt.wrapper as yt

        yql_token = sdk2.Vault.data("ANTIROBOT", "robot-antirobot-yql-token")
        yt_token = sdk2.Vault.data("ANTIROBOT", "robot-antirobot-yt-token")

        client = YqlClient(db='hahn', token=yql_token)
        yt.config.set_proxy("hahn")
        yt.config['token'] = yt_token
        root_in = '//logs/antirobot-daemon-log/30min'
        root_out = '//home/antirobot/toropov/30min_robots_diff'
        previous, last = sorted(yt.list(root_in))[-2:]

        if (last in yt.list(root_out)):
            return

        parameters = {
            '$table1': ValueBuilder.make_string(root_in + "/" + last),
            '$table2': ValueBuilder.make_string(root_in + "/" + previous),
        }

        real_filename = os.path.join(os.path.dirname(os.path.realpath(__file__)), "query.yql")
        query = open(real_filename).read()
        request = client.query(query)
        request.run(parameters=ValueBuilder.build_json_map(parameters))

        asn_names_url = "https://proxy.sandbox.yandex-team.ru/last/ASN_NAMES_RESOURCE"
        asn_names_filename = "AsnNames.tsv"
        urllib.urlretrieve(asn_names_url, asn_names_filename)

        asn_names = dict()
        for line in open(asn_names_filename):
            asn_num, asn_name = line.split('\t', 2)
            asn_names[asn_num] = asn_name.strip()

        try:
            table = next(iter(request.get_results()))
        except Exception:
            print(request)
            return

        table.fetch_full_data()

        index_of = dict()
        for index in range(len(table.columns)):
            index_of[table.columns[index][0]] = index

        data = []
        for row in table.rows:
            cnt = row[index_of["cnt"]]
            asn = row[index_of["ASN"]]
            rng = row[index_of["range"]]
            some_ips = row[index_of["some_ips"]]
            asn_name = asn_names[asn] if asn in asn_names else ""
            isp_name = row[index_of["isp_name"]]
            org_name = row[index_of["org_name"]]
            is_tor = row[index_of["is_tor"]]
            data.append({"Count": cnt, "ASN": asn, "ASN_name": asn_name, "ASN_range": rng, "ASN_ips_example": some_ips, "ISP_name": isp_name, "ORG_name": org_name, "Is_TOR": is_tor})

        out_table_name = root_out + "/" + last
        yt.write_table(out_table_name, data)

        expiration_time = datetime.datetime.utcnow() + datetime.timedelta(weeks=2)
        yt.set(out_table_name + "/@expiration_time", expiration_time.isoformat())
