# Нагрузочное тестирование аппхоста
Задача APP_HOST_LOAD_TEST предназначена для нагрузочного тестирования няня-сервиса с поднятым аппхостом с помощью танка. [Пример успешного запуска.](https://sandbox.yandex-team.ru/task/1026564130/view)

## Схема работы задачи.
1. Определяется няня-сервис, который нужно протестировать. Выбирается произвольный хост этого сервиса.
2. Создаются запросы для сервиса в понятном для танка формате. Файлов с запросами может быть несколько.
3. Производится обстрел выбранного хоста для каждого набора запросов.
4. Вычисляется, какой RPS может выдержать хост для каждого набора запросов.
5. Задача пишет в st-тикет о результатах стрельбы (если указано в параметрах).

## Необходимые доступы
Нужно следовать [инструкции](https://wiki.yandex-team.ru/load/howto/idm-puncher/) от команды танка. Если мишень находится в макросе `_APPHOST_TEST_*_NETS_` (аппхостовая вертикаль TEST), необходимые доступы для стрельбы общественного танка уже настроены.

В sandbox рекомендуется запускать таску от владельца APP_HOST.

## Параметры задачи
### Танк
**tank_names** – `nanny:production_yandex_tank` для стрельбы из общественного танка, либо список собственных танков в формате `host:port`. Для разовых или редких стрельб рекомендуется использовать общественный танк.
### Мишень
Можно задать двумя способами:
1. **nanny_service** – няня-сервис с поднятым аппхостом.
2. **beta** – название Yappy-беты.
**type_or_quota** – название типа или квоты нужной компоненты в бете.
В этом случае задача сама выберет сервис по бете и типу компоненты (или по бете и названию квоты в Yappy).

В обоих случаях танк обстреляет один произвольный хост выбранного няня-сервиса. На данный момент поддерживается только стрельба GET-запросами в http_adapter (порт N + 4).

### Запросы и схема нагрузки
**load_plan** – схема нагрузки. Подробнее можно прочитать [здесь](https://wiki.yandex-team.ru/load/howto/simple-start/#kakzapustittestcherezlunapark).
Запросы можно задать двумя способами:
1. **queries** – ресурс типа `AMMO_FILE`, содержащий запросы к аппхосту. Одна строка – один запрос.
2. **tests_cgi** – список GET-запросов для обстрела. Задача создаст однострочный `AMMO_FILE` для каждого.

В результате будет проведено несколько независимых последовательных стрельб – по одной для каждого принятого или сгенерированного `AMMO_FILE`.

Подробнее о запросах можно прочитать ниже в разделе "Графы для тестирования".

### Анализ результатов
После серии обстрелов задача анализирует их результаты и выдает предельный RPS, который сервис может выдержать, для каждого обстрела.
**time_threshold** – максимальное значение 0.95-квантиля времени ответа аппхоста (ms), при котором считается, что мишень выдержала нагрузку.
**rps_to_survive** – если это число окажется больше выдерживаемого RPS, задача завершится со статусом FAILURE.

### Репорты в тикет

**report_to_release_ticket** – если включено, задача попытается написать отчет в тикет, который можно задать двумя способами.
1. **default_release_ticket** – название тикета.
2. **rm_component** – название компоненты RM (app_host). Чтобы осмысленно использовать этот параметр, нужно запускать задачу из приемочной ветки.

Параметр **ticket** не связан с предыдущими параметрами. Это название тикета, к которому будет привязана стрельба в лунапарке. Если у вас такого нет, можно использовать APPHOST-3730.

## Графы для тестирования

Такие графы предлагается помещать в вертикаль [TEST](https://a.yandex-team.ru/arc/trunk/arcadia/apphost/conf/verticals/TEST). На данный момент существует один граф, предназначенный для тестирования танком: [echo_test](https://a.yandex-team.ru/arc/trunk/arcadia/apphost/conf/verticals/TEST/echo_test.json). Этот граф сходит в один [бекенд](https://nanny.yandex-team.ru/ui/#/services/catalog/apphost_loadtest_servant/), код которого можно найти [здесь](https://a.yandex-team.ru/arc/trunk/arcadia/apphost/servants/loadtest_servant). В запросах к нему стоит задать один из двух cgi-параметров:

1. **length=<число>**. Результатом выполнения графа станет случайная строка заданной длины.
2. **fast_error=1**. Результатом выполнения графа станет ошибка. Единственный бекенд вернет fast error.

Пример запроса: `/echo_test?length=50`
