import sandbox.common.types.task as ctt

from sandbox import sdk2
from sandbox.sdk2 import service_resources


class ApphostPerfTesting(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        with sdk2.parameters.RadioGroup('Task to run') as chosen_task:
            chosen_task.values['collect'] = chosen_task.Value('ApphostOrganicLogsCollector', default=True)
            chosen_task.values['shoot'] = chosen_task.Value('ApphostYappyBetaShooting')
            chosen_task.values['compare'] = chosen_task.Value('ApphostTankShootingRunner')

        with sdk2.parameters.Group('Default parameters') as default_parameters:
            vertical_name = sdk2.parameters.String('Vertical name', required=True)
            ctype = sdk2.parameters.String('ctype', required=True)
            logs_amount = sdk2.parameters.Integer('Amount of logs', required=True)
            tag = sdk2.parameters.String('Ammo tag', default='request')

        with sdk2.parameters.Group('ApphostYappyBetaShooting | ApphostTankShootingRunner') as shooting_comparing:
            nanny_service = sdk2.parameters.String('Nanny service name')
            tank_scheduling_config = sdk2.parameters.String('Scheduling config')
            apphost_executable = sdk2.parameters.Resource('Patched Apphost executable')
            patched_apphost_json = sdk2.parameters.Resource('Patched app_host.json')

        with sdk2.parameters.Group('ApphostTankShootingRunner') as comparing:
            prod_apphost_executable = sdk2.parameters.Resource('Production Apphost executable')

        with sdk2.parameters.Output:
            sub_task = sdk2.parameters.Task('Executing subtask')
            datalens_url = sdk2.parameters.String('Datalens url')

    def on_save(self):
        attrs = {
            "task_type": "APPHOST_PERF_TESTING",
        }
        res = service_resources.SandboxTasksBinary.find(attrs=attrs).first()
        self.Requirements.tasks_resource = res.id

    def _run_organic_logs_collector(self):
        from apphost.tools.load_testing.sandbox.ApphostOrganicLogsCollector import ApphostOrganicLogsCollector

        binary_task_resource = service_resources.SandboxTasksBinary.find(owner='APP_HOST', attrs={
            'task_type': 'APPHOST_ORGANIC_LOGS_COLLECTOR', }).first()
        task = ApphostOrganicLogsCollector(self, __requirements__={'tasks_resource': binary_task_resource},
                                           vertical_name=self.Parameters.vertical_name, ctype=self.Parameters.ctype,
                                           logs_amount=self.Parameters.logs_amount, )
        task.save()
        task.enqueue()

        return task

    def _run_yappy_beta_shooting(self):
        from apphost.tools.load_testing.sandbox.ApphostYappyBetaShooting import ApphostYappyBetaShooting

        binary_task_resource = service_resources.SandboxTasksBinary.find(owner='APP_HOST', attrs={
            'task_type': 'APPHOST_YAPPY_BETA_SHOOTING', }).first()
        task = ApphostYappyBetaShooting(self, __requirements__={'tasks_resource': binary_task_resource},
                                        vertical_name=self.Parameters.vertical_name, ctype=self.Parameters.ctype,
                                        tank_scheduling_config=self.Parameters.tank_scheduling_config,
                                        patched_apphost_json=self.Parameters.patched_apphost_json,
                                        apphost_executable=self.Parameters.apphost_executable,
                                        nanny_service=self.Parameters.nanny_service,
                                        logs_amount=self.Parameters.logs_amount, )
        task.save()
        task.enqueue()

        return task

    def _run_tank_shooting_runner(self):
        from apphost.tools.load_testing.sandbox.ApphostTankShootingRunner import ApphostTankShootingRunner

        binary_task_resource = service_resources.SandboxTasksBinary.find(owner='APP_HOST', attrs={
            'task_type': 'APPHOST_TANK_SHOOTING_RUNNER', }).first()
        task = ApphostTankShootingRunner(self, __requirements__={'tasks_resource': binary_task_resource},
                                         vertical_name=self.Parameters.vertical_name, ctype=self.Parameters.ctype,
                                         prod_apphost_executable=self.Parameters.prod_apphost_executable,
                                         tank_scheduling_config=self.Parameters.tank_scheduling_config,
                                         patched_apphost_json=self.Parameters.patched_apphost_json,
                                         apphost_executable=self.Parameters.apphost_executable,
                                         nanny_service=self.Parameters.nanny_service,
                                         logs_amount=self.Parameters.logs_amount, )
        task.save()
        task.enqueue()

        return task

    def on_execute(self):
        if self.Parameters.chosen_task == 'collect':
            self._run_organic_logs_collector()
        elif self.Parameters.chosen_task == 'shoot':
            self._run_yappy_beta_shooting()
        elif self.Parameters.chosen_task == 'compare':
            with self.memoize_stage.tank_shooting:
                self.Parameters.sub_task = self._run_tank_shooting_runner()
                raise sdk2.WaitTask(self.Parameters.sub_task, ctt.Status.SUCCESS)
            with self.memoize_stage.getting_datalens:
                datalens_url = self.Parameters.sub_task.Parameters.data_lens_chart
                self.Parameters.datalens_url = datalens_url
