# coding: utf-8

import logging

from sandbox.projects.app_host.BuildAppHostConfigBundle import BuildServiceResources, BuildTemplatesDir, \
    NoBackEndsInGraph
from sandbox.projects.common.app_host.options import ChooseVertical, GraphGenerator
from sandbox.projects.common.app_host.regular_build import save_run_info, has_changes_since_prev_run
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask

from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.parameters import SandboxArcadiaUrlParameter
from sandbox.sandboxsdk.task import SandboxTask


class BuildAndReleaseAppHostConfigBundle(ArcadiaTask):

    """Runs and releases BUILD_APP_HOST_CONFIG_BUNDLE task"""

    type = 'BUILD_AND_RELEASE_APP_HOST_CONFIG_BUNDLE'

    execution_space = 4000

    input_parameters = [ChooseVertical, GraphGenerator, SandboxArcadiaUrlParameter, NoBackEndsInGraph]

    def _wait_subtask(self, key, subtask):
        logging.info('Starting subtask {}'.format(subtask))
        self.ctx[key] = subtask.id
        self.wait_tasks(
            subtask,
            self.Status.Group.FINISH | self.Status.Group.BREAK,
            True,
            None
        )

    def _get_backends_task(self, task_id):
        bundle_task = SandboxTask(task_id)

        for t in bundle_task.list_subtasks(load=True):
            if t.type == 'BUILD_APP_HOST_BACKENDS_CONFIG':
                if not t.is_finished():
                    raise SandboxTaskFailureError("backends task is not finished")
                return t
        raise SandboxTaskFailureError("no backends task")

    def do_execute(self):
        config_bundle_task_id = 'config_bundle_task_id'

        if config_bundle_task_id not in self.ctx:
            self.ctx[BuildServiceResources.name] = False
            self.ctx[BuildTemplatesDir.name] = False

            save_run_info(self.ctx)
            has_changes = has_changes_since_prev_run(self.ctx, BuildAndReleaseAppHostConfigBundle.type, '/apphost')

            if has_changes:
                if not self.ctx.get(GraphGenerator.name):
                    context = self.ctx.copy()
                    context[GraphGenerator.name] = GraphGenerator.get_resource_from_ctx(self.ctx)
                else:
                    context = self.ctx

                subtask = self.create_subtask(
                    task_type='BUILD_APP_HOST_CONFIG_BUNDLE',
                    description=self.descr,
                    input_parameters=context,
                    priority=self.priority,
                    inherit_notifications=True
                )

                self._wait_subtask(config_bundle_task_id, subtask)

        else:
            bundle_task = self.ctx[config_bundle_task_id]
            backends_task = self._get_backends_task(bundle_task)

            self.create_release(
                backends_task.id,
                status='unstable',
                subject="{}".format(self.descr + ' (backends)')
            )

            self.create_release(
                bundle_task,
                status='unstable',
                subject="{}".format(self.descr)
            )


__Task__ = BuildAndReleaseAppHostConfigBundle
