# -*- coding: utf-8

import os
from sandbox import sdk2
import sandbox.common.types.task as ctt
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask


class AppHostPerftestServantBinary(sdk2.Resource):
    arcadia_build_path = 'apphost/tools/perftest_servant/perftest_servant'
    releasable = True
    any_arch = False
    auto_backup = True


class BuildAndReleaseAppHostPerftestServant(YaMakeTask, ReleaseToNannyTask):
    type = 'BUILD_AND_RELEASE_APP_HOST_PERFTEST_SERVANT'
    input_parameters = get_arcadia_params() + [
        build_parameters.UseArcadiaApiFuse(),
        build_parameters.AllowArcadiaApiFallback(),
    ] + ya_make_build_params()

    def get_resources(self):
        resources = {
            'description': 'AppHost perftest_servant executable',
            'resource_path': os.path.basename(AppHostPerftestServantBinary.arcadia_build_path),
            'resource_type': AppHostPerftestServantBinary
        }
        return {'project': resources}

    def get_targets(self):
        return [AppHostPerftestServantBinary.arcadia_build_path]

    def get_arts(self):
        return [{'path': AppHostPerftestServantBinary.arcadia_build_path}]

    def on_success(self):
        YaMakeTask.on_success(self)
        ReleaseToNannyTask.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject="AppHost perftest_servant",
            email_notifications=dict(to=[], cc=[]),
            release_comments="AppHost perftest_servant"
        ))


__Task__ = BuildAndReleaseAppHostPerftestServant
