import logging
from sandbox import sdk2
from sandbox import common
from sandbox.common.types import task as ctt
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class BuildAndReleaseHttpAdapterConfigBundle(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1000

    class Parameters(sdk2.Task.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl(required=True)
        with sdk2.parameters.CheckGroup("Choose vertical", required=True) as choose_vertical:
            choose_vertical.values.WEB = choose_vertical.Value("WEB", checked=False)
            choose_vertical.values.VIDEO = choose_vertical.Value("VIDEO", checked=False)
            choose_vertical.values.IMGS = choose_vertical.Value("IMGS", checked=False)
            choose_vertical.values.ATOM = choose_vertical.Value("ATOM", checked=False)
            choose_vertical.values.COMMON = choose_vertical.Value("COMMON", checked=False)
            choose_vertical.values.MAIL = choose_vertical.Value("MAIL", checked=False)
            choose_vertical.values.MAILCORP = choose_vertical.Value("MAILCORP", checked=False)
            choose_vertical.values.SHARED = choose_vertical.Value("SHARED", checked=False)
            choose_vertical.values.NEWS = choose_vertical.Value("NEWS", checked=False)

    def on_execute(self):
        with self.memoize_stage.create_tasks:
            logging.info("Create tasks")

            config_bundle_task = sdk2.Task["BUILD_APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE"]

            config_bundle = config_bundle_task(
                self,
                description=self.Parameters.description,
                choose_vertical=' '.join(self.Parameters.choose_vertical),
                build_service_resources=True,
                checkout_arcadia_from_url=self.Parameters.checkout_arcadia_from_url,
            ).enqueue()

            self.Context.config_bundle_id = config_bundle.id

            logging.info(self.Context.config_bundle_id)

            raise sdk2.WaitTask(
                [
                    self.Context.config_bundle_id,
                ],
                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                wait_all=True
            )

        with self.memoize_stage.release_tasks:
            logging.info("Release ready tasks")
            sub_tasks = self.find(status=ctt.Status.Group.BREAK + ctt.Status.Group.FINISH).limit(10)
            for task in sub_tasks:
                if task.status not in [ctt.Status.SUCCESS]:
                    raise SandboxTaskFailureError("Task {} failed".format(task.id))

            self.server.release(
                task_id=self.Context.config_bundle_id,
                type=ctt.ReleaseStatus.UNSTABLE,
                subject=self.Parameters.description
            )

            logging.info("Done releasing")
            raise sdk2.WaitTask(
                [
                    self.Context.config_bundle_id,
                ],
                common.utils.chain(ctt.Status.RELEASED, ctt.Status.NOT_RELEASED, ctt.Status.Group.BREAK),
                wait_all=True
            )

        with self.memoize_stage.check_if_tasks_released:
            logging.info("Checking if tasks released")
            sub_tasks = self.find(status=ctt.Status.Group.BREAK + ctt.Status.Group.FINISH).limit(10)
            for task in sub_tasks:
                if task.status not in [ctt.Status.RELEASED]:
                    raise SandboxTaskFailureError("Task {} failed".format(task.id))

            logging.info("Done checking")
