# -*- coding: utf-8 -*-
import os

import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.nanny.nanny as nanny
from sandbox import sdk2
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.resource_types import search_priemka_releasers


class AppHostModelBinary(sdk2.Resource):
    """
    AppHost model binary.
    """
    releasable = True
    any_arch = False
    releasers = search_priemka_releasers + ["robot-testenv"]
    auto_backup = True
    arcadia_build_path = 'apphost/daemons/app_host/app_host'


class BuildAppHost(YaMakeTask, nanny.ReleaseToNannyTask):
    """
    Build AppHost model binary.
    """
    type = 'BUILD_APPHOST'
    input_parameters = ya_make_build_params() + get_arcadia_params() + [
        build_parameters.UseArcadiaApiFuse(),
        build_parameters.AllowArcadiaApiFallback(),
    ]

    def get_resources(self):
        resources = {
            'description': 'Build executable',
            'resource_path': os.path.basename(AppHostModelBinary.arcadia_build_path),
            'resource_type': AppHostModelBinary,
        }
        return {'project': resources}

    def get_targets(self):
        return [AppHostModelBinary.arcadia_build_path]

    def get_arts(self):
        return [{'path': AppHostModelBinary.arcadia_build_path}]

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildAppHost
