# -*- coding: utf-8 -*-
import requests

from requests.adapters import HTTPAdapter


class ResolverApiException(Exception):
    """Ошибка при работе с resolver API."""
    pass


def _handle_http_error(e):
    """
    Если был получен ошибочный ответ от сервера,
    надо сформировать исключение ResolverApiException с телом ответа,
    т.к. в нём может содержаться полезная информация об ошибке.

    :type e: requests.HTTPError
    """
    message = \
        'Resolver responded with code {}. Body:\n{}'.format(
            e.response.status_code,
            e.response.content)
    return ResolverApiException(message)


class ResolverApiClient(object):
    def __init__(self, api_url):
        self._api_url = api_url.rstrip('/')
        self._session = requests.Session()
        self._session.mount(self._api_url, HTTPAdapter(max_retries=3))

    def get_term(self, term, contextOnline=False):
        _term = term
        if contextOnline:
            _term = 'C@ONLINE . {}'.format(term)
        try:
            r = self._session.get(
                '{}/v1/?term={}'.format(self._api_url, _term)
            )
            r.raise_for_status()
        except requests.HTTPError as e:
            raise _handle_http_error(e)
        except Exception as e:
            raise ResolverApiException(
                'Failed to call Resolver API. Error: {}'.format(e))
        return r.json()
