# -*- coding: utf-8 -*-
import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.projects.common.build.YaMake2 import YA_MAKE_CLIENT_TAGS
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.horizon.resources.binaries import HorizonAgentBinary, HorizonNoraAgentBinary

from sandbox.projects.app_host.resources import \
    AppHostDaemonExecutable, \
    AppHostResolverExecutable, \
    AppHostEvlogdumpExecutable, \
    AppHostGrpcClientExecutable, \
    AppHostServantClientExecutable, \
    AppHostInstancectlConf, \
    AppHostConfigBundleUnified, \
    PushClientExecutorExecutable, \
    AppHostDaemonExecutableWeb, \
    APPHOST_CERT


class BuildAppHostExecutables(YaMakeTemplate.YaMakeTemplate):
    """
        Build all AppHost executables.
    """
    class Parameters(YaMakeTemplate.get_project_params([
        AppHostDaemonExecutable,
        PushClientExecutorExecutable,
        AppHostEvlogdumpExecutable,
        AppHostGrpcClientExecutable,
        AppHostServantClientExecutable,
        AppHostInstancectlConf,
        AppHostConfigBundleUnified,
        HorizonAgentBinary,
        HorizonNoraAgentBinary,
        AppHostDaemonExecutableWeb,
        APPHOST_CERT
    ])):
        pass

    class Requirements(sdk2.Task.Requirements):
        client_tags = YA_MAKE_CLIENT_TAGS & ctc.Tag.GENERIC & ~ctc.Tag.Group.OSX
        disk_space = 1024 * 30
