import os.path

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.common.build.parameters as build_params
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.parameters import SandboxArcadiaUrlParameter
from sandbox.projects.common.nanny import nanny
import sandbox.projects.common.constants as consts
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.app_host.common import UseFuseRepositoryParameter


class BuildAppHostGraphGenerator(nanny.ReleaseToNannyTask, ArcadiaTask):

    """Builds graph_generator binary for app_host"""

    type = "BUILD_APP_HOST_GRAPH_GENERATOR"

    execution_space = 10000

    input_parameters = [SandboxArcadiaUrlParameter] + build_params.get_build_system_params()

    client_tags = ctc.Tag.Group.LINUX

    def do_execute(self):
        if self.ctx.get(UseFuseRepositoryParameter.name):
            with sdk.mount_arc_path(self.ctx[consts.ARCADIA_URL_KEY]) as arcadia_dir:
                self.build(arcadia_dir)
            return
        arcadia_dir = self.get_arcadia_src_dir()
        self.build(arcadia_dir)

    def build(self, arcadia_dir):
        url = self.ctx[consts.ARCADIA_URL_KEY]
        parsed_url = Arcadia.parse_url(url)
        assert parsed_url.revision

        # prepare build environment
        build_dir = self.abs_path("build")
        make_folder(build_dir)
        os.chdir(build_dir)

        sdk.do_build(
            self.ctx['build_system'],
            arcadia_dir,
            ["web/app_host/tools/graph_generator"],
            self.ctx['build_type'],
            clear_build=True,
            results_dir=build_dir
        )

        self.create_resource(
            description="APP_HOST_GRAPH_GENERATOR_EXECUTABLE@{}".format(parsed_url.revision),
            resource_path=os.path.join(build_dir, "web/app_host/tools/graph_generator/bin/graph_generator"),
            resource_type=resource_types.APP_HOST_GRAPH_GENERATOR_EXECUTABLE,
            arch="any"

        )


__Task__ = BuildAppHostGraphGenerator
