import os

from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as build_params

from sandbox.projects.app_host import resources as ah_resources


res = ah_resources.APP_HOST_NGINX


class BuildAppHostNginx(YaMakeTask):
    """Builds nginx for http_adapter"""

    type = "BUILD_APP_HOST_NGINX"

    input_parameters = [build_params.ArcadiaUrl]

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.ctx[build_params.CheckoutParameter.name] = True

    def get_targets(self):
        return [res.arcadia_build_path]

    def get_arts(self):
        return [{
            'path': res.arcadia_build_path
        }]

    def get_resources(self):
        url = self.ctx[build_params.ArcadiaUrl.name]
        parsed_url = Arcadia.parse_url(url)
        assert parsed_url.revision

        return {
            'project': {
                'description': res.name + '@' + parsed_url.revision,
                'resource_type': res,
                'resource_path': os.path.basename(res.arcadia_build_path)
            }
        }
