import glob
import os.path

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params
from sandbox.sandboxsdk.paths import copy_path, make_folder
from sandbox.sandboxsdk.parameters import SandboxArcadiaUrlParameter
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.common.nanny import nanny


class BuildAppHostTestServants(nanny.ReleaseToNannyTask, ArcadiaTask):

    """Builds a bundle with app_host test servants"""

    type = "BUILD_APP_HOST_TEST_SERVANTS"

    execution_space = 100000

    input_parameters = build_params.get_build_system_params() + [
        SandboxArcadiaUrlParameter
    ]

    client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX

    def do_execute(self):
        # prepare build environment
        build_dir = self.abs_path("build")
        make_folder(build_dir)
        os.chdir(build_dir)

        arcadia_dir = self.get_arcadia_src_dir()

        build_type = consts.RELEASE_BUILD_TYPE
        sdk.do_build(
            self.ctx['build_system'],
            arcadia_dir,
            ["apphost/tools"],
            build_type,
            clear_build=True,
            results_dir=build_dir
        )

        # create package
        url = self.ctx[consts.ARCADIA_URL_KEY]
        parsed_url = Arcadia.parse_url(url)
        assert parsed_url.revision
        pkg_name = "app_host_test_servants_%s" % parsed_url.revision

        package_dir = os.path.join(build_dir, pkg_name)
        os.chdir(build_dir)
        make_folder(package_dir)

        copy_path(
            os.path.join(build_dir, "apphost/tools/perftest_servant/perftest_servant"),
            os.path.join(package_dir, "perftest_servant")
        )
        copy_path(
            os.path.join(build_dir, "apphost/tools/caching_servant/caching_servant"),
            os.path.join(package_dir, "caching_servant")
        )
        run_process("tar czvf %s.tar.gz %s" % (pkg_name, pkg_name), shell=True)

        tar = glob.glob(os.path.join(build_dir, "*.tar.gz"))[-1]

        # save created package as resource
        resource_dir = self.abs_path()
        copy_path(tar, resource_dir)

        tar_name = os.path.basename(tar)

        self.create_resource(
            description=tar_name,
            resource_path=os.path.join(resource_dir, tar_name),
            resource_type=resource_types.APP_HOST_TEST_SERVANTS,
            arch=self.arch,
        )


__Task__ = BuildAppHostTestServants
