import os

from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common.build import ArcadiaTask as arcadia_task
from sandbox.projects.common.build import YaMake as yamake_task

from sandbox.projects.app_host import resources as app_host_resources


_TARGETS = {
    'make_tank_ammo': app_host_resources.APP_HOST_TOOL_MAKE_TANK_AMMO_EXECUTABLE,
}
_OUT_DIR = "out"


class BuildAppHostTools(yamake_task.YaMakeTask):
    type = "BUILD_APP_HOST_TOOLS"

    execution_space = yamake_task.YaMakeTask.execution_space + 10 * 1024

    input_parameters = \
        arcadia_task.gen_input_params({'tools': [key for key in _TARGETS]}) + \
        build_parameters.get_arcadia_params() + \
        yamake_task.ya_make_build_params()

    def get_arts(self):
        result = []
        for resource in self.__get_targets():
            result.append({
                'path': resource.arcadia_build_path,
                'dest': _OUT_DIR,
                'resource': str(resource)
            })
        return result

    def get_targets(self):
        return [os.path.dirname(elt['path']) for elt in self.get_arts()]

    def get_resources(self):
        result = {}
        for art in self.get_arts():
            base_path = os.path.basename(art['path'])
            result[base_path] = {
                "description": self.descr,
                "resource_path": os.path.join(_OUT_DIR, base_path),
                "resource_type": art['resource']
            }
        return result

    def __get_targets(self):
        for key, value in _TARGETS.iteritems():
            if self.ctx.get('tools') == 'build_all' or self.ctx.get('build_{}'.format(key)):
                yield value


__Task__ = BuildAppHostTools
