from sandbox import sdk2

from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.projects.app_host.ValidateHttpAdapterBeta.requesters import VideoDelayedView


class ValidateHttpAdapterBeta(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1000

    class Parameters(sdk2.Task.Parameters):
        beta_url = sdk2.parameters.Url("Set beta url", required=True)
        with sdk2.parameters.CheckGroup("Choose vertical") as verticals:
            verticals.values.WEB = verticals.Value("WEB", checked=True)
            verticals.values.VIDEO = verticals.Value("VIDEO", checked=True)
            verticals.values.IMGS = verticals.Value("IMGS", checked=True)
            verticals.values.ATOM = verticals.Value("ATOM", checked=True)
            verticals.values.COMMON = verticals.Value("COMMON", checked=True)
            verticals.values.MAIL = verticals.Value("MAIL", checked=True)
            verticals.values.MAILCORP = verticals.Value("MAILCORP", checked=True)
            verticals.values.SHARED = verticals.Value("SHARED", checked=True)
            verticals.values.NEWS = verticals.Value("NEWS", checked=False)

    def on_execute(self):

        vertical_map = {
            "VIDEO": [VideoDelayedView]
        }

        errors = []

        for vertical in self.Parameters.verticals:
            for test in vertical_map.get(vertical, []):
                for error in test(self.Parameters.beta_url).run():
                    errors.append(error)

        if errors:
            raise SandboxTaskFailureError(errors)
