import urlparse
import requests


class BaseRequester(object):
    def __init__(self, beta_url):
        self.name = self.__class__.__name__
        self.beta_url = beta_url

    def _get_requests(self):
        return [("dummy", "https://devnull.yandex.ru")]

    def send_requests(self):
        result = []
        for request_type, request_url in self._get_requests():
            req = requests.get(urlparse.urljoin(self.beta_url, request_url))
            result.append((request_type, req))

        return result

    def validate(self, request_type, result):

        if len(result.text) == 0:
            return "empty_answer"

        return False

    def run(self):
        errors = []
        for request_type, result in self.send_requests():
            error = self.validate(request_type, result)
            if error:
                errors.append((self.name, request_type, error))

        return errors


class VideoDelayedView(BaseRequester):
    def _get_requests(self):
        return [
            ("video_delayed_view", "/video/delayed_view?yandexuid=8442300171476787449")
        ]
