from sandbox.sandboxsdk.parameters import DictRepeater, SandboxStringParameter, SandboxBoolParameter


class ParentResourcesParameter(DictRepeater, SandboxStringParameter):
    name = 'parent_resources'
    description = 'Transfer resources to the parent task'
    ui = None

    @classmethod
    def resolve(cls, ctx):
        result = ctx.get(cls.name, {})

        if result is None:
            return {}
        else:
            return result


def get_url_attributes(parsed_url):
    attributes = {
        'arcadia_revision': parsed_url.revision,
        'arcadia_trunk': str(parsed_url.trunk),
        'arcadia_branch': str(parsed_url.branch),
        'arcadia_tag': str(parsed_url.tag)
    }

    return attributes


class UseFuseRepositoryParameter(SandboxBoolParameter):
    name = 'use_fuse_repository'
    description = 'Mount fuse repository'
    default_value = False
