from sandbox import sdk2

from sandbox.projects.resource_types import releasers as rr
from sandbox.projects.resource_types import APP_HOST_ABSTRACT_CONFIG, APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF,\
    APP_HOST_BUNDLE, APP_HOST_HTTP_ADAPTER_BUNDLE, APP_HOST_PRODUCTION_APP_HOST_JSON_VIDEO, \
    APP_HOST_PRODUCTION_APP_HOST_JSON_WEB, APP_HOST_PRODUCTION_APP_HOST_JSON_IMGS, \
    APP_HOST_PRODUCTION_INSTANCECTL_CONF, APP_HOST_GRAPH_NAME_MAPPING, APP_HOST_SRC_SETUP_BUNDLE, \
    APP_HOST_HTTP_ADAPTER_LOOP_CONF
from sandbox.projects.ydo.resource_types import ydo_releasers
from sandbox.projects.goods.resources import GOODS_RUNTIME_RELEASERS
from sandbox.projects.iot.resources import iot_releasers


class AppHostAbstractExecutable(sdk2.Resource):
    releasable = True
    executable = True
    auto_backup = True
    releasers = rr.apphost_releasers


class APP_HOST_ANY_CONFIG_BASE(sdk2.Resource):
    executable = False
    readable = True
    releasable = True
    auto_backup = True
    releasers = rr.apphost_releasers


class AppHostDaemonExecutable(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/daemons/app_host/app_host'


class AppHostDaemonExecutableWeb(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/daemons/app_host/web/app_host'


class PushClientExecutorExecutable(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/tools/push_client_executor/push_client_executor'


class AppHostResolverExecutable(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/daemons/resolver/resolver'


class AppHostEvlogdumpExecutable(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/tools/event_log_dump/event_log_dump'


class AppHostGrpcClientExecutable(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/tools/grpc_client/grpc_client'


class AppHostServantClientExecutable(AppHostAbstractExecutable):
    arcadia_build_path = 'apphost/tools/servant_client/servant_client'


class AppHostResource(sdk2.Resource):
    auto_backup = False
    releasers = rr.apphost_releasers


class HorizonAppHostInstancectlConf(APP_HOST_ANY_CONFIG_BASE):
    """
        app_host instancectl.conf for horizon verticals
    """
    pass


class APPHOST_PROTO_EVENTS_DESCR(APP_HOST_ANY_CONFIG_BASE):
    pass


class APPHOST_MAPPINGS_BUNDLE(sdk2.Resource):
    pass


class APPHOST_CERT(APP_HOST_ANY_CONFIG_BASE):
    arcadia_build_path = 'apphost/conf/allCAs/allCAs.pem'
    pass


class AppHostInstancectlConf(APP_HOST_ANY_CONFIG_BASE):
    arcadia_build_path = 'apphost/conf/instancectl/instancectl.conf'


class AppHostConfigBundleUnified(APP_HOST_ANY_CONFIG_BASE):
    arcadia_build_path = 'apphost/conf/combinator/generated/configs.tar.gz'


class AppHostDaemonResource(AppHostResource):
    earl_build_task = 'BUILD_APP_HOST_DAEMONS'


class AppHostToolResource(AppHostResource):
    releasers = rr.apphost_tool_releasers


class APP_HOST_TOOL_PVA_EXECUTABLE(AppHostToolResource):
    """
        PVA, a config glueing tool for app_host

    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'apphost/tools/pva/pva'


class APP_HOST_TOOL_EVENT_LOG_YQL_UDF_LIBRARY(AppHostToolResource):
    """
        YQL UDF library with AppHostEventLog::Parse(event), etc.

    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'yql/udfs/app_host'


class APP_HOST_NGINX(AppHostToolResource):
    """
        Nginx for http_adapter

    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'nginx'


class AppHostEarlDataResource(AppHostResource):
    executable = False
    releasable = True
    any_arch = True
    earl_tarball = False
    earl_dynamic_resource = False
    earl_versioned_files = []
    earl_build_task = 'BUILD_APP_HOST_EARL_DATA'


class APP_HOST_DAEMON_EARL_EXECUTABLE(AppHostDaemonResource):
    """
        Apphost graph management console
    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'apphost/daemons/earl/bin/earl'
    earl_path = 'bin/earl'
    earl_tarball = False
    earl_dynamic_resource = False


class APP_HOST_TOOL_MAKE_TANK_AMMO_EXECUTABLE(AppHostToolResource):
    """
        Generate apphost requests in 'tank full requests' format
    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'apphost/tools/make_tank_ammo/make_tank_ammo'


class APP_HOST_EARL_CONFIG_EARL_CONF(AppHostEarlDataResource):
    """
        Apphost Earl earl.conf main config
    """
    earl_path = 'config/earl.conf'


class APP_HOST_EARL_CONFIG_LOOP_CONF(AppHostEarlDataResource):
    """
        Apphost Earl loop.conf config
    """
    earl_path = 'config/loop.conf'


class APP_HOST_EARL_DATA(AppHostEarlDataResource):
    """
        Apphost Earl data bundle
    """
    earl_dynamic_resource = True
    earl_path = 'data'
    earl_versioned_files = ['index.html']
    earl_tarball = True


class APP_HOST_EARL_CONFIG_NGINX_CONF_TEMPLATE(AppHostEarlDataResource):
    """
        Apphost Earl nginx.conf.in config
    """
    earl_dynamic_resource = True
    earl_path = 'config/nginx.conf.in'


class APP_HOST_EARL_CONFIG_ISS_HOOK_NOTIFY(AppHostEarlDataResource):
    """
        Apphost Earl iss_hook_notify shell script
    """
    executable = True
    earl_path = 'config/iss_hook_notify.sh'


class APP_HOST_JSON_CONTEXTS(sdk2.Resource):
    releasers = rr.apphost_releasers


# TODO(APPHOST-2319) push-client.yml as separate resource for all verticals
class APP_HOST_PUSH_CLIENT_CONFIG_BASE(APP_HOST_ANY_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_WEB(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_DISTRICT(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_MUSIC(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_SHARED(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_COMMON(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_MAIL(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_MAILCORP(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_IMGS(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_CONFIG_VIDEO(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_PRODUCTION_PUSH_CLIENT_FORK_CONFIG_SHARED(APP_HOST_PUSH_CLIENT_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_BASE(APP_HOST_ANY_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_WEB(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_ATOM(APP_HOST_BACKENDS_CONFIG_BASE):
    releasers = rr.apphost_releasers + ['epar']
    pass


class APP_HOST_BACKENDS_CONFIG_IMGS(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_NEWS(APP_HOST_BACKENDS_CONFIG_BASE):
    releasers = rr.apphost_releasers + rr.news_releasers
    pass


class APP_HOST_BACKENDS_CONFIG_VIDEO(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_VIDEO_HOSTING(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_COMMON(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_MAIL(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_MAILCORP(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_SHARED(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BACKENDS_CONFIG_MUSIC(APP_HOST_BACKENDS_CONFIG_BASE):
    pass


class APP_HOST_BUNDLE_MAIL(APP_HOST_BUNDLE):
    pass


class APP_HOST_BUNDLE_MAILCORP(APP_HOST_BUNDLE):
    pass


class APP_HOST_BUNDLE_SHARED(APP_HOST_BUNDLE):
    pass


class APP_HOST_BUNDLE_DISTRICT(APP_HOST_BUNDLE):
    pass


class APP_HOST_BUNDLE_WEATHER(APP_HOST_BUNDLE):
    pass


class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_VIDEO_HOSTING(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup VIDEO_HOSTING config bundle
    """
    releasers = rr.apphost_releasers + ['robot-testenv', 'robot-srch-releaser']


class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_COMMON(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup COMMON config bundle
    """
    releasers = rr.apphost_releasers


class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_MAIL(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup MAIL config bundle
    """
    releasers = rr.apphost_releasers


class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_MUSIC(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup MUSIC config bundle
    """
    releasers = rr.music_search_releasers


class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_MAILCORP(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup MAILCORP config bundle
    """
    releasers = rr.apphost_releasers


class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_SHARED(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup SHARED config bundle
    """
    releasers = rr.apphost_releasers


class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_ISOLATED_CONF(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for instances running in their own namespaces
    """
    pass


class APP_HOST_SRC_SETUP_TESTING_LOOP_ISOLATED_CONF(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for instances running in their own namespaces
    """
    pass


class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_ISOLATED_CONF_VIDEO(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for instances running in their own namespaces
    """
    pass


class APP_HOST_SRC_SETUP_TESTING_LOOP_ISOLATED_CONF_VIDEO(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for instances running in their own namespaces
    """
    pass


class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_ISOLATED_CONF_IMGS(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup production IMGS loop.conf for instances running in their own namespaces
    """
    pass


class APP_HOST_SRC_SETUP_TESTING_LOOP_ISOLATED_CONF_IMGS(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup testing IMGS loop.conf for instances running in their own namespaces
    """
    pass


class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF_IMGS(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup production IMGS loop.conf
    """
    pass


class APP_HOST_SRC_SETUP_TESTING_LOOP_CONF_IMGS(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup testing IMGS loop.conf
    """
    pass


class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_MAIL(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_MAILCORP(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_SHARED(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_HTTP_ADAPTER_BUNDLE_MAIL(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


class APP_HOST_HTTP_ADAPTER_BUNDLE_MAILCORP(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


class APP_HOST_HTTP_ADAPTER_BUNDLE_SHARED(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


class APP_HOST_PRODUCTION_INSTANCECTL_CONF_SHARED(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for SHARED production
    """
    pass


class APP_HOST_HAMSTER_INSTANCECTL_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for hamster
    """
    pass


class APP_HOST_PRODUCTION_INSTANCECTL_ISOLATED_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for instances running in their own network and mount namespaces
    """
    pass


class APP_HOST_PRODUCTION_INSTANCECTL_ISOLATED_CONF_SHARED(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for SHARED production instances with network and mount isolation
    """
    pass


class APP_HOST_HAMSTER_INSTANCECTL_ISOLATED_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for instances running in their own network and mount namespaces
    """
    pass


class APP_HOST_TESTING_INSTANCECTL_ISOLATED_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for instances running in their own network and mount namespaces
    """
    pass


class APP_HOST_TESTING_INSTANCECTL_ISOLATED_CONF_MAIL(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for instances running in their own network and mount namespaces
    """
    pass


class APP_HOST_TESTING_INSTANCECTL_ISOLATED_CONF_MAILCORP(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for instances running in their own network and mount namespaces
    """
    pass


class APP_HOST_PERFTEST_INSTANCECTL_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for perftest installation instances
    """
    pass


class APP_HOST_PERFTEST_INSTANCECTL_ISOLATED_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for perftest installation instances isolated
    """
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_MAIL(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_MAILCORP(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_SHARED(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_WEATHER(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_PCODE(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_DISTRICT(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_PRODUCTION_APP_HOST_JSON_MUSIC(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_HAMSTER_APP_HOST_JSON_WEB(APP_HOST_PRODUCTION_APP_HOST_JSON_WEB):
    """
        app_host main config for WEB hamster
    """
    pass


class APP_HOST_HAMSTER_APP_HOST_JSON_IMGS(APP_HOST_PRODUCTION_APP_HOST_JSON_IMGS):
    """
        app_host main config for IMGS hamster
    """
    pass


class APP_HOST_HAMSTER_APP_HOST_JSON_VIDEO(APP_HOST_PRODUCTION_APP_HOST_JSON_VIDEO):
    """
        app_host main config for VIDEO hamster
    """
    pass


class APP_HOST_HAMSTER_APP_HOST_JSON_SHARED(APP_HOST_PRODUCTION_APP_HOST_JSON_SHARED):
    """
        app_host main config for SHARED hamster
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


class APP_HOST_DEV_APP_HOST_JSON_WEB(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for WEB dev
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON_IMGS(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for IMGS dev
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON_VIDEO(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for VIDEO dev
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON_COMMON(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for COMMON dev
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON_MAIL(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for MAIL dev
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON_MAILCORP(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for MAILCORP dev
    """
    pass


class APP_HOST_DEV_APP_HOST_JSON_SHARED(APP_HOST_DEV_APP_HOST_JSON):
    """
        app_host main config for SHARED dev
    """
    pass


class APP_HOST_CONFIG_BUNDLE_MAIL(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host MAIL config and graphs
    """
    pass


class APP_HOST_CONFIG_BUNDLE_MAILCORP(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host MAILCORP config and graphs
    """
    pass


class APP_HOST_CONFIG_BUNDLE_SHARED(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host SHARED config and graphs
    """
    pass


class APP_HOST_SRC_SETUP_BUNDLE_COMMON(APP_HOST_SRC_SETUP_BUNDLE):
    pass


class APP_HOST_SRC_SETUP_BUNDLE_MAIL(APP_HOST_SRC_SETUP_BUNDLE):
    pass


class APP_HOST_SRC_SETUP_BUNDLE_MAILCORP(APP_HOST_SRC_SETUP_BUNDLE):
    pass


class APP_HOST_SRC_SETUP_BUNDLE_SHARED(APP_HOST_SRC_SETUP_BUNDLE):
    releasers = APP_HOST_SRC_SETUP_BUNDLE.releasers + ydo_releasers + iot_releasers + ['MLMARINES']


class APP_HOST_SRC_SETUP_BUNDLE_YDO(APP_HOST_SRC_SETUP_BUNDLE):
    releasers = APP_HOST_SRC_SETUP_BUNDLE.releasers + ydo_releasers


class APP_HOST_SRC_SETUP_BUNDLE_GOODS(APP_HOST_SRC_SETUP_BUNDLE):
    releasers = APP_HOST_SRC_SETUP_BUNDLE.releasers + GOODS_RUNTIME_RELEASERS


class APP_HOST_SRC_SETUP_BUNDLE_VIDEO_HOSTING(APP_HOST_SRC_SETUP_BUNDLE):
    releasers = APP_HOST_SRC_SETUP_BUNDLE.releasers + rr.vh_frontend_releasers


class APP_HOST_SRC_SETUP_BUNDLE_MUSIC(APP_HOST_SRC_SETUP_BUNDLE):
    pass


class APP_HOST_GRAPH_NAME_MAPPING_MAIL(APP_HOST_GRAPH_NAME_MAPPING):
    pass


class APP_HOST_GRAPH_NAME_MAPPING_MAILCORP(APP_HOST_GRAPH_NAME_MAPPING):
    pass


class APP_HOST_GRAPH_NAME_MAPPING_SHARED(APP_HOST_GRAPH_NAME_MAPPING):
    pass


class APP_HOST_HTTP_ADAPTER_LOOP_CONF_SHARED(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        loop.conf for app_host's http_adapter (SHARED)
    """
    pass


class APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        isolated loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF_SHARED(APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF):
    """
        isolated loop.conf for app_host's http_adapter (SHARED)
    """
    pass


class APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF_COMMON(APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF):
    """
        isolated loop.conf for app_host's http_adapter (COMMON)
    """
    pass


class APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF_MAIL(APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF):
    """
        isolated loop.conf for app_host's http_adapter (MAIL)
    """
    pass


class APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF_MAILCORP(APP_HOST_HTTP_ADAPTER_LOOP_ISOLATED_CONF):
    """
        isolated loop.conf for app_host's http_adapter (MAILCORP)
    """
    pass


class APP_HOST_HTTP_ADAPTER_TESTING_LOOP_CONF(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_TESTING_LOOP_ISOLATED_CONF(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        isolated loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_TESTING_LOOP_ISOLATED_CONF_SHARED(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        isolated loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_TESTING_LOOP_ISOLATED_CONF_COMMON(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        isolated loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_TESTING_LOOP_ISOLATED_CONF_MAIL(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        isolated loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_TESTING_LOOP_ISOLATED_CONF_MAILCORP(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        isolated loop.conf for app_host's http_adapter
    """
    pass


class APP_HOST_HTTP_ADAPTER_NGINX_CONF_TMPL(APP_HOST_HTTP_ADAPTER_LOOP_CONF):
    """
        nginx conf template for app_host's http_adapter
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_ATOM(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (ATOM)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_NEWS(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (NEWS)
    """
    releasers = rr.apphost_releasers + rr.news_releasers
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_WEB(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (WEB)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_IMGS(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (IMGS)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_VIDEO(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (VIDEO)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_COMMON(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (COMMON)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_MAIL(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (MAIL)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_MAILCORP(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (MAILCORP)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_SHARED(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (SHARED)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_WEATHER(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (WEATHER)
    """
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_YABS(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_DISTRICT(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_PRODUCTION_RESOLVER_JSON_MUSIC(APP_HOST_ABSTRACT_CONFIG):
    pass


class APP_HOST_HAMSTER_RESOLVER_JSON_WEB(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (WEB)
    """
    pass


class APP_HOST_HAMSTER_RESOLVER_JSON_IMGS(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (IMGS)
    """
    pass


class APP_HOST_HAMSTER_RESOLVER_JSON_VIDEO(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (VIDEO)
    """
    pass


class APP_HOST_HAMSTER_RESOLVER_JSON_SHARED(APP_HOST_ABSTRACT_CONFIG):
    """
        resolver.json for app_host's resolver daemon (SHARED)
    """
    pass
