# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers

apphost_cachedaemon_releasers = resource_releasers.noapacheupper_releasers


class APPHOST_CACHEDAEMON_EXECUTABLE(sdk2.Resource):
    """
        Бинарь кэшдемона для аппхостовых графов
    """
    auto_backup = True
    releasable = True
    executable = True
    any_arch = False
    releasers = apphost_cachedaemon_releasers + ["robot-morty"]
    arcadia_build_path = 'web/daemons/cached'


class APPHOST_CACHEDAEMON_CONFIG(sdk2.Resource):
    """
        Конфиг кэшдемона для аппхостовых графов
    """
    auto_backup = True
    releasable = True
    any_arch = True
    releasers = apphost_cachedaemon_releasers + ["robot-morty"]


class APPHOST_CACHEDAEMON_INSTANCECTL(sdk2.Resource):
    """
        instancectl.conf (loop.conf) для сервиса кэшдемона для аппхостовых графов
    """
    auto_backup = True
    releasable = True
    any_arch = True
    releasers = apphost_cachedaemon_releasers + ["robot-morty"]
    arcadia_build_path = 'web/daemons/cached/instancectl_conf'
    arcadia_build_name = 'instancectl_production_apphost_cachedaemon.conf'
    config_name = 'instancectl_production_apphost_cachedaemon.conf'


class APPHOST_CACHEDAEMON_HAMSTER_INSTANCECTL(sdk2.Resource):
    """
        instancectl.conf (loop.conf) для сервиса кэшдемона для аппхостовых графов
    """
    auto_backup = True
    releasable = True
    any_arch = True
    releasers = apphost_cachedaemon_releasers + ["robot-morty"]
    arcadia_build_path = 'web/daemons/cached/instancectl_conf'
    arcadia_build_name = 'instancectl_hamster_apphost_cachedaemon.conf'
    config_name = 'instancectl_hamster_apphost_cachedaemon.conf'


class APPHOST_CACHEDAEMON_PRODUCTION_INSTANCECTL(sdk2.Resource):
    """
        instancectl.conf (loop.conf) для сервиса кэшдемона для аппхостовых графов
    """
    auto_backup = True
    releasable = True
    any_arch = True
    releasers = apphost_cachedaemon_releasers + ["robot-morty"]
    arcadia_build_path = 'web/daemons/cached/instancectl_conf'
    arcadia_build_name = 'instancectl_production_apphost_cachedaemon.conf'
    config_name = 'instancectl_production_apphost_cachedaemon.conf'
