from sandbox import sdk2


class ComdepMultikReleasableResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['COMDEP-MULTIK', 'robot-testenv']


class ComdepMultikReleasableAutoPackedResource(ComdepMultikReleasableResource):
    pack_tar = True


class MultikWebClassifierServer(ComdepMultikReleasableAutoPackedResource):
    """Executable binary for the MultiK classifier server."""
    pass


class MultikKdClassifierData(ComdepMultikReleasableResource):
    """MultiK classifier data for ComDep stand."""
    pass


class MultikStandNginx(ComdepMultikReleasableAutoPackedResource):
    """Nginx YandexDeploy-layer resoursce for Multik Stand"""
    pass


class MultikStandServer(ComdepMultikReleasableAutoPackedResource):
    """Server YandexDeploy-layer resoursce for Multik Stand"""
    pass


class MultikStandWorker(ComdepMultikReleasableAutoPackedResource):
    """Worker YandexDeploy-layer resoursce for Multik Stand"""
    pass


class MultikStandFrontend(ComdepMultikReleasableAutoPackedResource):
    """Frontend YandexDeploy-layer resoursce for Multik Stand"""
    pass
