import os
import shutil

from sandbox import sdk2
import sandbox.projects.common.arcadia.sdk as arcadiasdk
from sandbox.projects.april.multik.resources import MultikStandNginx
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.irt.IrtBuild import IrtBuild


class BuildMultikNginx(ReleaseToYaDeployTask2, IrtBuild):
    """
    Class for building MultiK Nginx Layer
    """
    YP_TOKEN_YAV_SECRET_ID = 'sec-01fy9cyrxbrkv405eja5g8ddtb'

    class Parameters(IrtBuild.Parameters):
        pass

    def on_execute(self):
        binary_files, revision = self.build(
            ['nginx/bin-noperl'],
            str(self.path('build')),
            revision=self.Parameters.arcadia_revision
        )
        result = sdk2.ResourceData(MultikStandNginx(
            self,
            'Multik Nginx Build {}'.format(self.Parameters.arcadia_revision),
            'multik_nginx',
        ))
        result_dir = str(result.path)
        os.mkdir(result_dir)

        os.makedirs(os.path.join(result_dir, 'etc'))
        os.makedirs(os.path.join(result_dir, 'usr', 'sbin'))
        os.makedirs(os.path.join(result_dir, 'var', 'lib', 'nginx'))
        os.makedirs(os.path.join(result_dir, 'var', 'log', 'nginx'))

        with arcadiasdk.mount_arc_path(sdk2.svn.Arcadia.replace(self.Parameters.checkout_arcadia_from_url, revision=revision)) as a_arcadia_path:
            shutil.copytree(
                os.path.join(a_arcadia_path, 'nginx', 'bin', 'debians', 'nginx'),
                os.path.join(result_dir, 'etc', 'nginx')
            )

            os.makedirs(os.path.join(result_dir, 'etc', 'nginx', 'conf.d'))

            shutil.copy(
                os.path.join(a_arcadia_path, 'april', 'multik', 'stand', 'docker', 'nginx.conf.template'),
                os.path.join(result_dir, 'etc', 'nginx')
            )

            shutil.copy(
                os.path.join(a_arcadia_path, 'april', 'multik', 'stand', 'docker', 'configure_nginx.sh'),
                os.path.join(result_dir, 'usr', 'sbin')
            )

            shutil.copy(
                os.path.join(a_arcadia_path, 'april', 'multik', 'stand', 'docker', 'multik.conf'),
                os.path.join(result_dir, 'etc', 'nginx', 'conf.d', 'multik.conf')
            )

        for bin_file in binary_files:
            shutil.copy(bin_file, os.path.join(result_dir, 'usr', 'sbin'))
