import os
import shutil

from sandbox import sdk2
from sandbox.projects.april.multik.resources import MultikStandServer
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.irt.IrtBuild import IrtBuild


class BuildMultikWebServer(ReleaseToYaDeployTask2, IrtBuild):
    """
    Class for building MultiK web server
    """
    YP_TOKEN_YAV_SECRET_ID = 'sec-01fy9cyrxbrkv405eja5g8ddtb'

    class Parameters(IrtBuild.Parameters):
        project_name = sdk2.parameters.String('Name of deploy project, that resource is built for', default=None, required=False)

    def on_execute(self):
        targets = ['april/multik/stand/server/project/app',
                   'april/multik/stand/server/project/manage']

        binary_files, revision = self.build(
            targets,
            str(self.path('build')),
            platform=self.Parameters.platform,
            revision=self.Parameters.arcadia_revision,
            arc_review=self.Parameters.arcanum_review,
            debug=self.Parameters.debug
        )

        result = sdk2.ResourceData(MultikStandServer(
            self,
            'Multik Web App server {} {}'.format(self.Parameters.arcadia_revision, self.Parameters.debug),
            'multik_server',
        ))
        result_dir = str(result.path)
        os.mkdir(result_dir)

        self.copy_files({
            'april/multik/stand/server/run.sh': result_dir
        })
        for bin_file in binary_files:
            shutil.copy(bin_file, result_dir)
