import os
import shutil

from sandbox import sdk2
from sandbox.projects.april.multik.resources import MultikStandWorker
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.irt.IrtBuild import IrtBuild


class BuildMultikWorker(ReleaseToYaDeployTask2, IrtBuild):
    """
    Class for building MultiK worker binary
    """
    YP_TOKEN_YAV_SECRET_ID = 'sec-01fy9cyrxbrkv405eja5g8ddtb'

    class Parameters(IrtBuild.Parameters):
        project_name = sdk2.parameters.String('Name of deploy project, that resource is built for', default=None, required=False)

    def on_execute(self):
        targets = ['april/multik/stand/worker']

        binary_files, revision = self.build(
            targets,
            str(self.path('build')),
            platform=self.Parameters.platform,
            revision=self.Parameters.arcadia_revision,
            arc_review=self.Parameters.arcanum_review,
            debug=self.Parameters.debug
        )

        result = sdk2.ResourceData(MultikStandWorker(
            self,
            'Multik Worker binary {} {}'.format(self.Parameters.arcadia_revision, self.Parameters.debug),
            'multik_worker',
        ))
        result_dir = str(result.path)
        os.mkdir(result_dir)

        for bin_file in binary_files:
            shutil.copy(bin_file, result_dir)
