# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.release_machine.core import const as rm_const


class MultikBigInfuseBanners(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """Make a big infuse using user's table with banners for the infuse and required categories for these banners."""

    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

        yav_secret_id = sdk2.parameters.String('YAV stand-secrets\' id', default='sec-01fwe7afw5mjj360q8w0mhx5cq', required=True)
        src_yt_proxy = sdk2.parameters.String('Source table YT proxy', default='hahn', required=True)
        dst_yt_proxy = sdk2.parameters.String('Destination stand tables YT proxy', default='markov', required=True)
        input_yt_table = sdk2.parameters.String('Input tablepath with the banners for infuse', required=True)
        title_key = sdk2.parameters.String('Banner\'s title key in the input table', default='title', required=True)
        body_key = sdk2.parameters.String('Banner\'s body key in the input table', default='body', required=True)
        href_key = sdk2.parameters.String('Banner\'s href key in the input table', default='href', required=True)
        categories_key = sdk2.parameters.String('Banner\'s categories key in the input table', default='categories', required=True)
        yt_stand_path = sdk2.parameters.String('YT stand path', default='//home/comdep-multik/stand', required=True)

        with sdk2.parameters.RadioGroup('Stand (and classifier) stage type') as stand_stage:
            stand_stage.values[rm_const.ReleaseStatus.stable] = stand_stage.Value(value='stable')
            stand_stage.values[rm_const.ReleaseStatus.prestable] = stand_stage.Value(value='prestable')
            stand_stage.values[rm_const.ReleaseStatus.testing] = stand_stage.Value(value='testing')
            stand_stage.values[rm_const.ReleaseStatus.unstable] = stand_stage.Value(value='unstable', default=True)

        erase_stand_user_changes = sdk2.parameters.Bool("Define the necessity for erasing current user's changes for infuse banners in the stand.", default=False, required=True)

        postgresql_hosts = sdk2.parameters.String(
            'Comma separated stand PostgreSQL hosts (in Yandex.Cloud).',
            default='sas-lg2g7ftbr0kz8ynr.db.yandex.net,vla-nzyau2ihvmg6z9t0.db.yandex.net',
            required=True,
        )
        postgresql_port = sdk2.parameters.Integer('PostgreSQL port', default=6432, required=True)
        postgresql_user = sdk2.parameters.String('User for connecting to stand PostgreSQL.', default='multik', required=True)

    def on_execute(self):
        import april.multik.stand.big_infuse as big_infuse

        secrets = sdk2.yav.Secret(self.Parameters.yav_secret_id).data()
        src_yt_client = big_infuse.get_yt_client(self.Parameters.src_yt_proxy, secrets['YT_TOKEN'])
        dst_yt_client = big_infuse.get_yt_client(self.Parameters.dst_yt_proxy, secrets['YT_TOKEN'], True)

        big_infuse.make_big_infuse(
            self.author,
            secrets['YT_TOKEN'],
            secrets['SANDBOX_TOKEN'],
            secrets['YP_TOKEN'],
            self.Parameters.yav_secret_id,
            src_yt_client,
            dst_yt_client,
            self.Parameters.input_yt_table,
            self.Parameters.title_key,
            self.Parameters.body_key,
            self.Parameters.href_key,
            self.Parameters.categories_key,
            self.Parameters.yt_stand_path,
            self.Parameters.stand_stage,
            [x.strip() for x in self.Parameters.postgresql_hosts.split(',')],
            self.Parameters.postgresql_port,
            self.Parameters.postgresql_user,
            secrets['POSTGRESQL_DB_PASSWORD'],
            self.Parameters.erase_stand_user_changes,
        )
