from sandbox import sdk2
from sandbox.projects.common import binary_task


class MultikImportBanners(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

        yav_secret_id = sdk2.parameters.String('YAV stand-secrets\' id', default='sec-01fwe7afw5mjj360q8w0mhx5cq', required=True)
        src_yt_proxy = sdk2.parameters.String('YT proxy with input data', default='hahn', required=True)
        src_yt_pool = sdk2.parameters.String('Pool for input YT proxy', default='multik')
        banners_data_path = sdk2.parameters.String('YT path to the actual banners data', required=True)
        banners_categories = sdk2.parameters.String('YT path to the actual categories data for the banners', required=True)
        full_banners_info = sdk2.parameters.String('YT path to the full banners with categories', required=True)
        dst_yt_proxy = sdk2.parameters.String('YT proxy with output stand data (dyntables)', default='markov', required=True)
        stand_banner_data_dir = sdk2.parameters.String('YT directory with a stand banners data', required=True)
        stand_banner_labels_table = sdk2.parameters.String('YT path to a stand categories data (of all banners)', required=True)

    def on_execute(self):
        secrets = sdk2.yav.Secret(self.Parameters.yav_secret_id).data()

        import april.multik.stand.import_banners as stand_import_banners
        src_yt_client = stand_import_banners.get_source_yt_client(
            self.Parameters.src_yt_proxy,
            secrets['YT_TOKEN'],
            self.Parameters.src_yt_pool,
        )
        dst_yt_client = stand_import_banners.get_destination_yt_client(
            self.Parameters.dst_yt_proxy,
            secrets['YT_TOKEN'],
        )
        stand_import_banners.run_import_banners(
            src_yt_client,
            dst_yt_client,
            self.Parameters.banners_data_path,
            self.Parameters.banners_categories,
            self.Parameters.full_banners_info,
            self.Parameters.stand_banner_data_dir,
            self.Parameters.stand_banner_labels_table
        )
