# -*- coding: utf-8 -*-

import os

from sandbox import sdk2
from sandbox.projects.april.multik.resources import MultikKdClassifierData
from sandbox.projects.common import binary_task
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.release_machine.core import const as rm_const


RELEASE_RESOURCE_NAME = 'MULTIK_KD_CLASSIFIER_DATA'


class MultikInfuse(ReleaseToYaDeployTask2, binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Infuse new C++ classifier using an actual classifier and YT-table with banners' diff
    """
    YP_TOKEN_YAV_SECRET_ID = 'sec-01fy9cyrxbrkv405eja5g8ddtb'

    class Parameters(sdk2.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

        yav_secret_id = sdk2.parameters.String('YAV stand-secrets\' id', default='sec-01fwe7afw5mjj360q8w0mhx5cq', required=True)
        yt_proxy = sdk2.parameters.String('YT proxy', default='hahn', required=True)
        yt_stand_full_path = sdk2.parameters.String('YT path to the stand directory (with stage)', required=True)
        with sdk2.parameters.RadioGroup('Stand (and classifier) stage type') as stage_type:
            stage_type.values[rm_const.ReleaseStatus.stable] = stage_type.Value(value='stable')
            stage_type.values[rm_const.ReleaseStatus.prestable] = stage_type.Value(value='prestable')
            stage_type.values[rm_const.ReleaseStatus.testing] = stage_type.Value(value='testing')
            stage_type.values[rm_const.ReleaseStatus.unstable] = stage_type.Value(value='unstable', default=True)

        with sdk2.parameters.RadioGroup('Index part for rebuild') as index_part:
            index_part.values['stage'] = index_part.Value(value='stage', default=True)
            index_part.values['trunk'] = index_part.Value(value='trunk')

    def on_execute(self):
        secrets = sdk2.yav.Secret(self.Parameters.yav_secret_id).data()
        os.environ['SANDBOX_TOKEN'] = secrets['SANDBOX_TOKEN']
        os.environ['YT_TOKEN'] = secrets['YT_TOKEN']
        os.environ['YT_PROXY'] = self.Parameters.yt_proxy
        os.environ['YT_FULL_TABLE_PREFIX'] = self.Parameters.yt_stand_full_path

        result_resource = sdk2.ResourceData(MultikKdClassifierData(
            self,
            'Rebuild classifier within Multik infuse process',
            'classifier',
        ))

        import april.multik.stand.classifier_builder as classifier_builder
        classifier_builder.upgrade_classifier_data(
            classifier_builder.IndexPart[self.Parameters.index_part],
            str(result_resource.path),
            self.Parameters.stage_type,
            RELEASE_RESOURCE_NAME,
            self.Parameters.yt_proxy,
            secrets['YT_TOKEN'],
            secrets['SANDBOX_TOKEN'],
        )
