from sandbox import sdk2
from sandbox.projects.common import binary_task
import os
import logging

from sandbox.projects.release_machine.core import const as rm_const


class MultikNightlyIndexMerge(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Parameters):

        project_name = sdk2.parameters.String('Name of Deploy project (e.g. kd-multik)', required=True)
        yav_secret_id = sdk2.parameters.String('YAV stand-secrets\' id', default='sec-01fwe7afw5mjj360q8w0mhx5cq', required=True)
        with sdk2.parameters.RadioGroup('Merge environment') as environment:
            environment.values['production'] = environment.Value(value='production')
            environment.values['prestable'] = environment.Value(value='prestable')
            environment.values['development'] = environment.Value(value='development')
            environment.values['testing'] = environment.Value(value='testing')

        proxy = sdk2.parameters.String('YT proxy', default='hahn', required=True)
        table_prefix = sdk2.parameters.String('YT table prefix (e.g //home/multik)', required=True)

        with sdk2.parameters.RadioGroup('Logging level') as log_level:
            log_level.values['INFO'] = log_level.Value(value='INFO', default=True)
            log_level.values['ERROR'] = log_level.Value(value='ERROR')
            log_level.values['DEBUG'] = log_level.Value(value='DEBUG')

        ext_params = binary_task.binary_release_parameters(stable=True)

    class Requirements(sdk2.Task.Requirements):
        ram = 1024 * 256  # 256Gb
        cores = 8

    def on_execute(self):
        super(MultikNightlyIndexMerge, self).on_execute()
        os.environ['LOG_LEVEL'] = self.Parameters.log_level
        os.environ['YENV_TYPE'] = self.Parameters.environment
        os.environ['YT_PROXY'] = self.Parameters.proxy
        os.environ['YT_TABLE_PREFIX'] = self.Parameters.table_prefix

        secret = sdk2.yav.Secret(self.Parameters.yav_secret_id)
        sandbox_token = secret.data()['SANDBOX_TOKEN']
        yp_token = secret.data()['YP_TOKEN']
        yt_token = secret.data()['YT_TOKEN']

        os.environ['YT_TOKEN'] = yt_token

        logging.basicConfig(level=self.Parameters.log_level)
        stage_type = {
            'production': rm_const.ReleaseStatus.stable,
            'prestable': rm_const.ReleaseStatus.prestable,
            'testing': rm_const.ReleaseStatus.testing,
            'development': rm_const.ReleaseStatus.unstable,
        }[self.Parameters.environment]

        import april.multik.stand.stage_merge as merger
        merger.IndexMerger(
            yt_token,
            self.Parameters.table_prefix,
            sandbox_token,
            self.Parameters.project_name,
            stage_type,
            self.Parameters.yav_secret_id,
            True,
            yp_token
        ).start_merge()
