from sandbox import sdk2


RELEASERS = [
    "ilikepugs",
    "kikht",
    "nslus",
    "tldr",
    "spreis",
    "robot-srch-releaser",
    "robot-arc-deploy",
    "otarakan",
    "gotocoding",
]


class ArcBrewTap(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS
    ttl = "inf"


class ArcLauncher(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS
    ttl = "inf"
    sync_upload_to_mds = True


class ArcDocs(sdk2.Resource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class Git2ArcPackage(sdk2.Resource):
    """
        Git to arc converter package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ArcConvertGitPackage(sdk2.Resource):
    """
        Git to arc converter package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ArcMigrationUploaderPackage(sdk2.Resource):
    """
        Migration uploader package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ArcIdmPackage(sdk2.Resource):
    """
        Arc idm system service package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ArcAdminPackage(sdk2.Resource):
    """
        Arc admin system service package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ARCD_PACKAGE(sdk2.Resource):
    """
        Arc proxy server package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class SVN2ARC_PACKAGE(sdk2.Resource):
    """
        Svn to arc converter package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ARC_PULLD_PACKAGE(sdk2.Resource):
    """
        Arc pull-requests robot package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ARC_PULLD_PROXY_PACKAGE(sdk2.Resource):
    """
        Arc pull-requests proxy package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ARC_HTTPD_PACKAGE(sdk2.Resource):
    """
        Arc http service package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ARC_SAMOGON_PACKAGE(sdk2.Resource):
    """
        Arc samogon plugin
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class SVN2ARC_MIGRATOR_PACKAGE(sdk2.Resource):
    """
        Svn to arc migrator package
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    ttl = "inf"


class ArcQuickRefsServerBinary(sdk2.Resource):
    """
        Arc quick_refs_server binary
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS + ["and42"]
    ttl = "inf"
