import json
import logging

from sandbox import sdk2
from sandbox.projects.common import binary_task


logger = logging.getLogger(__name__)


class ReleaseArcadiaDocs(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Release previously deployed Arcadia DOCS artifact to production or testing environment
    """

    ARCANUM_TOKEN = 'robot-cozmo:robot-cozmo-arcanum-token'

    class Requirements(sdk2.Requirements):
        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        import sandbox.projects.arcadia.DeployArcadiaDocs.lib as release_lib

        projects = sdk2.parameters.JSON('Mapping of project name (as of .yfm) to its version to be released', default='{}', required=True)
        with sdk2.parameters.CheckGroup('Release projects to') as environments:
            environments.choices=(('testing', release_lib.VIEWER_TESTING_ENV), ('production', release_lib.VIEWER_PROD_ENV))

        secret = sdk2.parameters.YavSecret('OAuth token to authorize release request', default=None)

        with sdk2.parameters.Group('Task executor') as task_executor:
            ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Output:
            released_projects = sdk2.parameters.JSON('Released projects')


    def on_execute(self):
        super(ReleaseArcadiaDocs, self).on_execute()

        import sandbox.projects.arcadia.DeployArcadiaDocs.lib as release_lib

        projects = self.Parameters.projects
        trunk_projects = {}
        non_trunk_projects = {}
        for name, data in projects.iteritems():
            data['environments'] = self.Parameters.environments
            if data.get('is_trunk', False):
                trunk_projects[name] = data
            else:
                non_trunk_projects[name] = data

        ua = '{}:{}'.format(self.type.name, self.id)

        if self.Parameters.secret:
            token = self.Parameters.secret.data()[self.Parameters.secret.default_key]
        else:
            token = sdk2.Vault.data(*self.ARCANUM_TOKEN.split(':'))

        logger.debug('Trunk projects: %s', trunk_projects)
        release_lib.release(trunk_projects, is_trunk=True, user_agent=ua, token=token)

        logger.debug('Non-trunk projects: %s', non_trunk_projects)
        release_lib.release(non_trunk_projects, is_trunk=False, user_agent=ua, token=token)

        self.Parameters.released_projects = projects
