from sandbox import sdk2


ARCANUM_RELEASERS = [
    'albazh',
    'skel',
    'sareyu',
    'gemberg',
    'tumenbaev',
    'teplosvet',
    'leotru',
    'dmitko',
    'dsamuylov',
    'sharepo',
    'robot-arcanum',
    'dimello',
    'maratik'
]

DOC_CLUSTER_RELEASERS = [
    'rudskoy',
    'albazh',
    'deshevoy',
    'workfork',
    'mironov',
    'dmitryrusanov',
    'robot-srch-releaser',
]


class ARCANUM_SAMOGON_PACKAGE(sdk2.Resource):
    """ Arcanum Samogon package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCANUM_RENDERERS_PACKAGE(sdk2.Resource):
    """ Arcanum Renderers package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCANUM_SERVER_PACKAGE(sdk2.Resource):
    """ Arcanum Server package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCANUM_SERVER_PACKAGE_2(sdk2.Resource):
    """ Arcanum Server package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCANUM_DOVECOTE_PACKAGE(sdk2.Resource):
    """ Arcanum Dovecote package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCANUM_SERVER_PYTHON_UTILITIES_PACKAGE(sdk2.Resource):
    """ Arcanum Server Python utilities package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCANUM_UI_PACKAGE(sdk2.Resource):
    """ Arcanum UI package """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ARCANUM_RELEASERS


class ARCADIA_DOCUMENTATION(sdk2.Resource):
    """ Documentation Devtools cluster """
    releasers = DOC_CLUSTER_RELEASERS
    releasable = True
    auto_backup = True
    any_arch = False
    service = sdk2.parameters.String("Devtools Service Name", default='')
    arcadia_path = sdk2.parameters.String("Doc Target Path In Arcadia Repository", default='')
