from enum import Enum

from sandbox.projects.autobudget.audit.lib.query.cpc import QUERY as CPC_QUERY
from sandbox.projects.autobudget.audit.lib.query.cpc_versioned import QUERY as CPC_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.cpm import QUERY as CPM_QUERY
from sandbox.projects.autobudget.audit.lib.query.cpm_versioned import PRE_QUERY as CPM_VERSIONED_PRE_QUERY
from sandbox.projects.autobudget.audit.lib.query.cpm_versioned import QUERY as CPM_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.cpv_versioned import QUERY as CPV_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.cpa import QUERY as CPA_QUERY
from sandbox.projects.autobudget.audit.lib.query.daily_budget_week import QUERY as DAILY_BUDGET_WEEK_QUERY
from sandbox.projects.autobudget.audit.lib.query.daily_budget_week_versioned import QUERY as DAILY_BUDGET_WEEK_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.strategy_daily_budget_week_versioned import QUERY as STRATEGY_DAILY_BUDGET_WEEK_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.daily_budget import QUERY as DAILY_BUDGET_QUERY
from sandbox.projects.autobudget.audit.lib.query.daily_budget_versioned import QUERY as DAILY_BUDGET_VERSIONING_QUERY
from sandbox.projects.autobudget.audit.lib.query.period_budget import QUERY as PERIOD_BUDGET_QUERY
from sandbox.projects.autobudget.audit.lib.query.period_budget_versioned import PRE_QUERY as PERIOD_BUDGET_VERSIONED_PRE_QUERY
from sandbox.projects.autobudget.audit.lib.query.period_budget_versioned import QUERY as PERIOD_BUDGET_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.strategy_period_budget_versioned import PRE_QUERY as STRATEGY_PERIOD_BUDGET_VERSIONED_PRE_QUERY
from sandbox.projects.autobudget.audit.lib.query.strategy_period_budget_versioned import QUERY as STRATEGY_PERIOD_BUDGET_VERSIONED_QUERY
from sandbox.projects.autobudget.audit.lib.query.fix_cpm import QUERY as FIX_CPM_QUERY
from sandbox.projects.autobudget.audit.lib.query.fix_cpm import POST_QUERY as FIX_CPM_POST_QUERY


class AuditType(Enum):
    CUSTOM = 'Custom'
    CPC = 'CPC'
    CPC_VERSIONED = 'CPC versioned'
    CPM = 'CPM'
    CPM_VERSIONED = 'CPM versioned'
    CPV_VERSIONED = 'CPV versioned'
    CPA = 'CPA'
    DAILY_BUDGET_WEEK = 'Daily budget week'
    DAILY_BUDGET_WEEK_VERSIONED = 'Daily budget week versioned'
    STRATEGY_DAILY_BUDGET_WEEK_VERSIONED = 'Strategy daily budget week versioned'
    DAILY_BUDGET = 'Daily budget'
    DAILY_BUDGET_VERSIONED = 'Daily budget versioned'
    PERIOD_BUDGET = 'Period budget'
    PERIOD_BUDGET_VERSIONED = 'Period budget versioned'
    STRATEGY_PERIOD_BUDGET_VERSIONED = 'Strategy period budget versioned'
    FIX_CPM = 'Fix CPM'


DEFAULT_PRE_QUERIES = {
    AuditType.CPM_VERSIONED: CPM_VERSIONED_PRE_QUERY,
    AuditType.PERIOD_BUDGET_VERSIONED: PERIOD_BUDGET_VERSIONED_PRE_QUERY,
    AuditType.STRATEGY_PERIOD_BUDGET_VERSIONED: STRATEGY_PERIOD_BUDGET_VERSIONED_PRE_QUERY,
}


DEFAULT_QUERIES = {
    AuditType.CPC: CPC_QUERY,
    AuditType.CPC_VERSIONED: CPC_VERSIONED_QUERY,
    AuditType.CPM: CPM_QUERY,
    AuditType.CPM_VERSIONED: CPM_VERSIONED_QUERY,
    AuditType.CPV_VERSIONED: CPV_VERSIONED_QUERY,
    AuditType.CPA: CPA_QUERY,
    AuditType.DAILY_BUDGET_WEEK: DAILY_BUDGET_WEEK_QUERY,
    AuditType.DAILY_BUDGET_WEEK_VERSIONED: DAILY_BUDGET_WEEK_VERSIONED_QUERY,
    AuditType.STRATEGY_DAILY_BUDGET_WEEK_VERSIONED: STRATEGY_DAILY_BUDGET_WEEK_VERSIONED_QUERY,
    AuditType.DAILY_BUDGET: DAILY_BUDGET_QUERY,
    AuditType.DAILY_BUDGET_VERSIONED: DAILY_BUDGET_VERSIONING_QUERY,
    AuditType.PERIOD_BUDGET: PERIOD_BUDGET_QUERY,
    AuditType.PERIOD_BUDGET_VERSIONED: PERIOD_BUDGET_VERSIONED_QUERY,
    AuditType.STRATEGY_PERIOD_BUDGET_VERSIONED: STRATEGY_PERIOD_BUDGET_VERSIONED_QUERY,
    AuditType.FIX_CPM: FIX_CPM_QUERY,
}


DEFAULT_POST_QUERIES = {
    AuditType.FIX_CPM: FIX_CPM_POST_QUERY,
}

__all__ = ['AuditType', 'DEFAULT_QUERIES', 'DEFAULT_POST_QUERIES', 'DEFAULT_PRE_QUERIES']
