QUERY = '''
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
-- CPA audit --
---------------

-- Helpers:

$ToSeconds = ($datetime) -> {
    RETURN DateTime::ToSeconds($datetime);
};

-- Arguments:

$now = DateTime::MakeTzDatetime(TzDatetime('{{ Now }},Europe/Moscow'));

$startPeriod = $now - DateTime::IntervalFromDays(23);
$DateFormat = DateTime::Format("%Y-%m-%d");
$day = $DateFormat($startPeriod);

$badLogIDs = (
    SELECT
        logid
    FROM
        RANGE('//home/logfeller/logs/bs-action-checked-log/stream/1d', $day)
    WHERE
        isgoodconversion AND
        autobudgetoptions like '%paid-actions%'
    GROUP BY
        logid,
        actioncostcur
    HAVING SUM(sign) < 0
);

SELECT
    $ToSeconds($now) as RunTime,
    orderid AS OrderID,
    actioncostcur AS ActionCostCur,
    logid AS LogID,
    autobudgetavgcpacur AS AutobudgetAvgCpaCur,
FROM
    RANGE('//home/logfeller/logs/bs-action-checked-log/stream/1d', $day)
WHERE
    isgoodconversion AND
    autobudgetoptions like '%paid-actions%' AND
    actioncostcur > autobudgetavgcpacur AND
    sign > 0 AND
    logid NOT IN $badLogIDs
;
'''
