QUERY = '''
-- CPC audit --
---------------

-- Helpers:

$ToTimestamp = ($seconds) -> {
    RETURN DateTime::MakeTzTimestamp(AddTimezone(DateTime::FromSeconds(CAST($seconds AS Uint32)), 'Europe/Moscow'));
};

$RoundToWeekStart = ($timestamp) -> {
    RETURN DateTime::MakeTzTimestamp(DateTime::StartOfWeek($timestamp));
};

$ToSeconds = ($timestamp) -> {
    RETURN DateTime::ToSeconds($timestamp);
};

-- Arguments:

$Now = CurrentUtcTimestamp();
$Now = DateTime::MakeTzTimestamp(AddTimezone($Now, 'Europe/Moscow'));

$CurWeek = $RoundToWeekStart($Now);

$PrevWeek = $CurWeek - DateTime::IntervalFromDays(7);

-- Audit logic:

$CheckIfHasRestart = ($start_time, $finish_time, $next_start_time) -> {
    RETURN ($next_start_time < $finish_time)
        OR (DateTime::ToDays($ToTimestamp($finish_time) - $ToTimestamp($start_time)) < 7);
};

$GetAcceptableExceedRate = ($clicks, $start_time, $week, $next_start_time) -> {
    RETURN IF(
        ($clicks < 100)
        OR $CheckIfHasRestart($start_time, $week + DateTime::ToSeconds(DateTime::IntervalFromDays(7)), $next_start_time),
        100.0,
        4.0);
};

$GetExceed = ($expected, $actual) -> {
    RETURN $actual - $expected;
};

$GetExceedRate = ($target, $cost, $units) -> {
    $fraction = IF($target > 0 AND $units > 0, 1.0 * $cost / ($units * $target), 1) - 1;
    RETURN Math::Round($fraction * 100, -2);
};

$GetCPU = ($cost, $units) -> {
    RETURN 1.0 * $cost / $units;
};

$OrderStartTimes = SELECT
    OrderID, StartTime, Week
FROM
    `//home/yabs/stat/AutobudgetAuditCPCv2`
GROUP BY
    OrderID, StartTime, Week
;

$OrderStartTimesSequence = SELECT
    A.OrderID AS OrderID,
    A.StartTime AS StartTime,
    MIN(IF(B.StartTime > A.StartTime, B.StartTime, A.Week + DateTime::ToSeconds(DateTime::IntervalFromDays(7)))) AS NextStartTime,
FROM
    $OrderStartTimes AS A
INNER JOIN
    $OrderStartTimes AS B
ON
    A.OrderID = B.OrderID
GROUP BY
    A.OrderID, A.StartTime
;

$LastWeekOrders = SELECT *
FROM
    `//home/yabs/stat/AutobudgetAuditCPCv2`
WHERE
    $ToTimestamp(Week) = $PrevWeek
;

SELECT
    $ToSeconds($Now) as RunTime,
    T.OrderID AS OrderID,
    $GetExceed(AvgCPC, $GetCPU(Cost, Clicks)) as Exceed,
    $GetExceed(AvgCPCCur, $GetCPU(CostCur, Clicks)) as ExceedCur,
    $GetExceedRate(AvgCPC, Cost, Clicks) as ExceedRate,
    $GetExceedRate(AvgCPCCur, CostCur, Clicks) as ExceedCurRate,
    "week" as LimitType,
    WeekLimit as LimitBudget,
    WeekLimitCur as LimitBudgetCur,
    AvgCPC as LimitAvgCPC,
    AvgCPCCur as LimitAvgCPCCur,
    Cost as Budget,
    CostCur as BudgetCur,
    $GetCPU(Cost, Clicks) as AvgCPC,
    $GetCPU(CostCur, Clicks) as AvgCPCCur,
    Clicks,
    AutobudgetStartTime as AutobudgetStartTime,
    T.Week as PeriodStartTime,
    $ToSeconds($ToTimestamp(T.Week) + DateTime::IntervalFromDays(7)) as PeriodFinishTime,
    FirstEvent,
    LastEvent
FROM
    $LastWeekOrders as T
INNER JOIN
    $OrderStartTimesSequence AS S
ON
    T.OrderID = S.OrderID AND T.StartTime = S.StartTime
WHERE
    (AvgCPC > 0 OR AvgCPCCur > 0)
    AND (
        (NOT IsCurrency AND $GetExceedRate(AvgCPC, Cost, Clicks) > $GetAcceptableExceedRate(Clicks, T.StartTime, Week, S.NextStartTime)) OR
        (IsCurrency AND $GetExceedRate(AvgCPCCur, CostCur, Clicks) > $GetAcceptableExceedRate(Clicks, T.StartTime, Week, S.NextStartTime))
    )
;

SELECT
    $ToSeconds($Now) as RunTime,
    COUNT(*) as TotalCheckedRows,
FROM
    $LastWeekOrders
;
'''
