QUERY = '''
-- CPM audit --
---------------

-- Helpers:

$ToTimestamp = ($seconds) -> {
    RETURN DateTime::MakeTzTimestamp(AddTimezone(DateTime::FromSeconds(CAST($seconds AS Uint32)), 'Europe/Moscow'));
};

$ToSeconds = ($timestamp) -> {
    RETURN DateTime::ToSeconds($timestamp);
};

-- Arguments:

$Now = CurrentUtcTimestamp();
$Now = DateTime::MakeTzTimestamp(AddTimezone($Now, 'Europe/Moscow'));

$Today = DateTime::MakeTzTimestamp(DateTime::StartOfDay($Now));

$Yesterday = $Today - DateTime::IntervalFromDays(1);

-- Audit logic:

$CheckIfHappenedYesterday = ($timestamp) -> {
    RETURN $Yesterday <= $timestamp AND $timestamp <= $Today;
};

$CheckIfHasRestart = ($start_time, $finish_time, $next_start_time) -> {
    RETURN ($next_start_time < $finish_time)
        OR (DateTime::ToDays($ToTimestamp($finish_time) - $ToTimestamp($start_time)) < 7);
};

$GetAcceptableExceedRate = ($limit_type, $shows, $start_time, $finish_time, $next_start_time) -> {
    RETURN IF(
        ($shows < 10000)
        OR (
            ($limit_type == "week")
            AND $CheckIfHasRestart($start_time, $finish_time, $next_start_time)
        ),
        100.0,
        4.0);
};

$GetExceed = ($expected, $actual) -> {
    RETURN $actual - $expected;
};

$GetExceedRate = ($target, $cost, $units) -> {
    $fraction = IF($target > 0 AND $units > 0, 1.0 * $cost / ($units * $target), 1) - 1;
    RETURN Math::Round($fraction * 100, -2);
};

$GetCPU = ($cost, $units) -> {
    RETURN 1.0 * $cost / $units;
};

$GetLimitType = ($weekLimit, $periodLimit) -> {
    RETURN IF($weekLimit > 0, "week", "period");
};

$GetLimitBudget = ($weekLimit, $periodLimit) -> {
    RETURN MAX_OF($weekLimit, $periodLimit);
};


$OrderStartTimes = SELECT
    OrderID, StartTime, FinishTime
FROM
    `//home/yabs/stat/AutobudgetAuditCPM`
GROUP BY
    OrderID, StartTime, FinishTime
;

$OrderStartTimesSequence = SELECT
    A.OrderID AS OrderID,
    A.StartTime AS StartTime,
    MIN(IF(B.StartTime > A.StartTime, B.StartTime, A.FinishTime)) AS NextStartTime,
FROM
    $OrderStartTimes AS A
INNER JOIN
    $OrderStartTimes AS B
ON
    A.OrderID = B.OrderID
GROUP BY
    A.OrderID, A.StartTime
;

$AuditStats = SELECT
    OrderID,
    AutobudgetStartTime,
    StartTime,
    MAX_BY(FinishTime, LastEvent) AS FinishTime,
    MAX_BY(WeekLimit, LastEvent) AS WeekLimit,
    MAX_BY(WeekLimitCur, LastEvent) AS WeekLimitCur,
    MAX_BY(PeriodLimit, LastEvent) AS PeriodLimit,
    MAX_BY(PeriodLimitCur, LastEvent) AS PeriodLimitCur,
    MAX_BY(AvgCPM, LastEvent) AS AvgCPM,
    MAX_BY(AvgCPMCur, LastEvent) AS AvgCPMCur,
    MAX_BY(IsCurrency, LastEvent) AS IsCurrency,
    SUM(Cost) AS Cost,
    SUM(CostCur) AS CostCur,
    SUM(Shows) AS Shows,
    MIN(FirstEvent) AS FirstEvent,
    MAX(LastEvent) AS LastEvent,
FROM
    `//home/yabs/stat/AutobudgetAuditCPM`
GROUP BY
    OrderID, AutobudgetStartTime, StartTime
;

$YesterdayFinishedOrderAudit = SELECT *
FROM
    $AuditStats
WHERE
    $CheckIfHappenedYesterday($ToTimestamp(FinishTime))
;

SELECT
    $ToSeconds($Now) as RunTime,
    Audit.OrderID as OrderID,
    $GetExceed(AvgCPM, $GetCPU(Cost, Shows)) as Exceed,
    $GetExceed(AvgCPMCur, $GetCPU(CostCur, Shows)) as ExceedCur,
    $GetExceedRate(AvgCPM, Cost, Shows) as ExceedRate,
    $GetExceedRate(AvgCPMCur, CostCur, Shows) as ExceedCurRate,
    $GetLimitType(WeekLimit, PeriodLimit) as LimitType,
    $GetLimitBudget(WeekLimit, PeriodLimit) as LimitBudget,
    $GetLimitBudget(WeekLimitCur, PeriodLimitCur) as LimitBudgetCur,
    AvgCPM as LimitAvgCPM,
    AvgCPMCur as LimitAvgCPMCur,
    Cost as Budget,
    CostCur as BudgetCur,
    $GetCPU(Cost, Shows) as AvgCPM,
    $GetCPU(CostCur, Shows) as AvgCPMCur,
    Shows,
    AutobudgetStartTime as AutobudgetStartTime,
    Audit.StartTime as PeriodStartTime,
    MIN_OF(FinishTime, NextStartTime) as PeriodFinishTime,
    FirstEvent,
    LastEvent
FROM
    $YesterdayFinishedOrderAudit AS Audit
INNER JOIN
    $OrderStartTimesSequence AS S
ON
    Audit.OrderID = S.OrderID AND Audit.StartTime = S.StartTime
WHERE
    (AvgCPM > 0 OR AvgCPMCur > 0)
    AND (
        (
            NOT IsCurrency
            AND $GetExceedRate(AvgCPM, Cost, Shows) > $GetAcceptableExceedRate(
                $GetLimitType(WeekLimit, PeriodLimit), Shows, Audit.StartTime, FinishTime, NextStartTime)
        ) OR (
            IsCurrency
            AND $GetExceedRate(AvgCPMCur, CostCur, Shows) > $GetAcceptableExceedRate(
                $GetLimitType(WeekLimit, PeriodLimit), Shows, Audit.StartTime, FinishTime, NextStartTime)
        )
    )
    AND $CheckIfHappenedYesterday($ToTimestamp(FinishTime))
;

SELECT
    $ToSeconds($Now) as RunTime,
    COUNT(*) as TotalCheckedRows,
FROM
    $YesterdayFinishedOrderAudit
;
'''
