QUERY = '''
-- Daily budget audit --
------------------------

-- Helpers:

$ToTimestamp = ($seconds) -> {
    RETURN DateTime::MakeTzDatetime(AddTimezone(DateTime::FromSeconds(CAST($seconds AS Uint32)), 'Europe/Moscow'));
};

$ToSeconds = ($timestamp) -> {
    RETURN DateTime::ToSeconds($timestamp);
};

-- Arguments:

$Now = CurrentUtcTimestamp();
$Now = DateTime::MakeTzTimestamp(AddTimezone($Now, 'Europe/Moscow'));

$Today = DateTime::MakeTzTimestamp(DateTime::StartOfDay($Now));

$Yesterday = $Today - DateTime::IntervalFromDays(1);

-- Audit logic:

$MinExceedRate = 30.0;

$GetExceed = ($target, $real) -> {
    RETURN $real - $target;
};

$GetExceedRate = ($target, $real) -> {
    $fraction = IF($target > 0, 1.0 * $real / $target, 1) - 1;
    RETURN Math::Round($fraction * 100, -2);
};

$CheckIfLimitExceeded = ($abOrderLimit, $cost) -> {
    RETURN $GetExceedRate($abOrderLimit, $cost) > $MinExceedRate;
};

$FixPriceOrders = SELECT
    OrderID,
FROM
    `//home/yabs/dict/CaesarAutoBudgetOrderWithHistory`
WHERE
    $ToTimestamp(StartTime) < $Today
GROUP BY
    OrderID
HAVING MAX_BY(
        (LimitDayMoney > 0 OR LimitDayMoneyCur > 0) AND (PeriodBudgetLimit > 0 OR PeriodBudgetLimitCur > 0),
        StartTime)
;

$AuditDailyLimits = FROM
    `//home/yabs/stat/AutobudgetAuditDailyLimit`
SELECT
    OrderID,
    AutobudgetStartTime,
    Day,
    SOME(IsCurrency) AS IsCurrency,
    MAX(DayLimit) AS DayLimit,
    MAX(DayLimitCur) AS DayLimitCur,
    MIN(FirstEvent) AS FirstEvent,
    MAX(LastEvent) AS LastEvent,
    SUM(Cost) AS Cost,
    SUM(CostCur) AS CostCur,
    SUM(Shows) AS Shows,
    SUM(Clicks) AS Clicks,
WHERE
    $ToTimestamp(Day) = $Yesterday
GROUP BY
    OrderID, AutobudgetStartTime, Day
;

$YesterdayAuditDailyLimits = SELECT *
FROM
    $AuditDailyLimits
WHERE
    $ToTimestamp(Day) = $Yesterday
;

$MaxDailyLimit = FROM
        `//home/yabs/dict/CaesarAutoBudgetOrderWithHistory` AS abowh
    INNER JOIN
        $AuditDailyLimits AS adl
    ON
        adl.OrderID = abowh.OrderID AND adl.AutobudgetStartTime = abowh.StartTime
    SELECT
        OrderID,
        StartTime,
        MAX(abowh.LimitDayMoney) AS MaxLimitDayMoney,
        MAX(abowh.LimitDayMoneyCur) AS MaxLimitDayMoneyCur,
    WHERE
        $ToTimestamp(LastUpdateTime) between $Yesterday and $Today
    GROUP BY
        abowh.OrderID AS OrderID, abowh.StartTime AS StartTime
;

$FinalLimit = ($Limit, $MaxLimitFromHistory) -> {
    RETURN MAX_OF($Limit, COALESCE($MaxLimitFromHistory, 0));
};

$MaxDailyLimit = FROM $MaxDailyLimit AS A
LEFT JOIN (
    FROM
        `//home/yabs/dict/CaesarAutoBudgetOrderWithHistory`
    SELECT
        OrderID,
        StartTime,
        MAX_BY(LimitDayMoney, LastUpdateTime) AS MaxLimitDayMoney,
        MAX_BY(LimitDayMoneyCur, LastUpdateTime) AS MaxLimitDayMoneyCur,
    WHERE $ToTimestamp(LastUpdateTime) < $Yesterday
    GROUP BY OrderID, StartTime
) AS B
ON
    A.OrderID = B.OrderID AND A.StartTime = B.StartTime
SELECT
    A.OrderID AS OrderID,
    A.StartTime AS StartTime,
    $FinalLimit(A.MaxLimitDayMoney, B.MaxLimitDayMoney) AS MaxLimitDayMoney,
    $FinalLimit(A.MaxLimitDayMoneyCur, B.MaxLimitDayMoneyCur) AS MaxLimitDayMoneyCur,
;

SELECT
    $ToSeconds($Now) as RunTime,
    A.OrderID as OrderID,
    "daily" as LimitType,
    $FinalLimit(DayLimit, MaxLimitDayMoney) as LimitBudget,
    $FinalLimit(DayLimitCur, MaxLimitDayMoneyCur) as LimitBudgetCur,

    A.Cost as Budget,
    A.CostCur as BudgetCur,

    $GetExceed($FinalLimit(DayLimit, MaxLimitDayMoney), A.Cost) as Exceed,
    $GetExceed($FinalLimit(DayLimitCur, MaxLimitDayMoneyCur), A.CostCur) as ExceedCur,
    $GetExceedRate($FinalLimit(DayLimit, MaxLimitDayMoney), A.Cost) as ExceedRate,
    $GetExceedRate($FinalLimit(DayLimitCur, MaxLimitDayMoneyCur), A.CostCur) as ExceedCurRate,

    A.AutobudgetStartTime as AutobudgetStartTime,
    A.Day as PeriodStartTime,
    $ToSeconds($ToTimestamp(A.Day) + DateTime::IntervalFromDays(1)) as PeriodFinishTime,
    A.FirstEvent as FirstEvent,
    A.LastEvent as LastEvent,
FROM $YesterdayAuditDailyLimits AS A
LEFT JOIN $MaxDailyLimit AS M ON A.OrderID = M.OrderID
LEFT ONLY JOIN $FixPriceOrders as FP on A.OrderID = FP.OrderID
WHERE
    (
        $FinalLimit(DayLimit, MaxLimitDayMoney) > 0
        OR $FinalLimit(DayLimitCur, MaxLimitDayMoneyCur) > 0
    )
    AND (
        (NOT IsCurrency AND $CheckIfLimitExceeded($FinalLimit(DayLimit, MaxLimitDayMoney), A.Cost))
        OR (IsCurrency AND $CheckIfLimitExceeded($FinalLimit(DayLimitCur, MaxLimitDayMoneyCur), A.CostCur))
    )
;

SELECT
    $ToSeconds($Now) as RunTime,
    COUNT(*) as TotalCheckedRows,
FROM
    $YesterdayAuditDailyLimits
;
'''
