QUERY = '''
-- FixCPM audit --
------------------


-- Helpers:

$ToSeconds = ($datetime) -> {
    RETURN DateTime::ToSeconds($datetime);
};

$RoundToDay = ($datetime) -> {
    RETURN DateTime::MakeTzDatetime(DateTime::StartOfDay($datetime));
};


-- Arguments:

$now = DateTime::MakeTzDatetime(TzDatetime('{{ Now }},Europe/Moscow'));
$today = $RoundToDay($now);
$tableFrom = '{{ table_from }}';
$tableTo = '{{ table_to }}';


-- Audit logic:

SELECT
    $ToSeconds($today) AS RunTime,
    CAST(orderid AS Int64) AS OrderID,
    CAST(autobudgetstrategyid AS Int64) AS StrategyID,
    CAST(logid AS UInt64) AS LogID,
    CAST(eventtime AS Int64) AS EventTime,
    CAST(sourcecostcur AS Int64) AS SourceCostCur,
    CAST(realcostcur AS Int64) AS RealCostCur,
    CAST(eventcostcur AS Int64) AS EventCostCur,
    CAST(initcosttaxfree AS Int64) AS InitCostTaxFree,
    CAST(costtaxfree AS Int64) AS CostTaxFree,
    CAST(costcur AS Int64) AS CostCur,
    CAST(sourcecost AS Int64) AS SourceCost,
    CAST(realcost AS Int64) AS RealCost,
    CAST(initcost AS Int64) AS InitCost,
    CAST(eventcost AS Int64) AS EventCost,
FROM
    RANGE(`//logs/bs-chevent-log/stream/5min`, $tableFrom, $tableTo)
WHERE
    orderbanneroptions LIKE '%fix-price-order%'
    AND eventcost <> '0'
    AND (
           sourcecost <> eventcost
        OR sourcecostcur <> realcostcur
    )
;

SELECT
    $ToSeconds($today) AS RunTime,
    COUNT(*) AS TotalCheckedRows,
FROM
    RANGE(`//logs/bs-chevent-log/stream/5min`, $tableFrom, $tableTo)
WHERE
    orderbanneroptions LIKE '%fix-price-order%'
;
'''

POST_QUERY = '''
-- Check Fix-CPM audit

$ToDatetime = ($ts) -> {
    RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($ts AS Uint32)))
};

$LocalizeDatetime = ($dt) -> {
    RETURN DateTime::MakeTzDatetime(AddTimezone($dt, 'Europe/Moscow'))
};

$ToLocalTzDatetime = ($ts) -> {
    RETURN $LocalizeDatetime($ToDatetime($ts))
};

$RoundToDay = ($datetime) -> {
    RETURN DateTime::MakeTzDatetime(DateTime::StartOfDay($datetime));
};

$ToSeconds = ($datetime) -> {
    RETURN DateTime::ToSeconds($datetime);
};

-- Arguments:
$runTimestamp = {{ run_time }};
$today = $RoundToDay($ToLocalTzDatetime($runTimestamp));

SELECT
    RunTime,
    OrderID,
    StrategyID,
    LogID,
    $ToLocalTzDatetime(EventTime) AS EventTime,
    SourceCost,
    RealCost,
    InitCost,
    EventCost,
    SourceCostCur,
    RealCostCur,
    EventCostCur,
    InitCostTaxFree,
    CostTaxFree,
FROM
    `//home/yabs/autobudget/AuditFixCPM`
WHERE
    RunTime = $ToSeconds($today)
;
'''
