QUERY = '''
-- Period budget audit --
-------------------------

-- Helpers:

$ToTimestamp = ($seconds) -> {
    RETURN DateTime::MakeTzTimestamp(AddTimezone(DateTime::FromSeconds(CAST($seconds AS Uint32)), 'Europe/Moscow'));
};

$ToSeconds = ($timestamp) -> {
    RETURN DateTime::ToSeconds($timestamp);
};

-- Arguments:

$Now = CurrentUtcTimestamp();
$Now = DateTime::MakeTzTimestamp(AddTimezone($Now, 'Europe/Moscow'));

$Today = DateTime::MakeTzTimestamp(DateTime::StartOfDay($Now));

-- Audit logic:

$MinExceedRate = 0.0;

$GetExceed = ($target, $real) -> {
    RETURN $real - $target;
};

$GetExceedRate = ($target, $real) -> {
    $fraction = IF($target > 0, 1.0 * $real / $target, 1) - 1;
    RETURN Math::Round($fraction * 100, -2);
};

$GetLimitType = ($weekLimit, $periodLimit) -> {
    RETURN IF($weekLimit > 0, "week", "period");
};

$GetLimitBudget = ($weekLimit, $periodLimit) -> {
    RETURN MAX_OF($weekLimit, $periodLimit);
};

$AuditStats = SELECT
    OrderID,
    AutobudgetStartTime,
    StartTime,
    MAX_BY(FinishTime, LastEvent) AS FinishTime,
    MAX_BY(WeekLimit, LastEvent) AS WeekLimit,
    MAX_BY(WeekLimitCur, LastEvent) AS WeekLimitCur,
    MAX_BY(PeriodLimit, LastEvent) AS PeriodLimit,
    MAX_BY(PeriodLimitCur, LastEvent) AS PeriodLimitCur,
    MAX_BY(AvgCPM, LastEvent) AS AvgCPM,
    MAX_BY(AvgCPMCur, LastEvent) AS AvgCPMCur,
    MAX_BY(IsCurrency, LastEvent) AS IsCurrency,
    SUM(Cost) AS Cost,
    SUM(CostCur) AS CostCur,
    SUM(Shows) AS Shows,
    MIN(FirstEvent) AS FirstEvent,
    MAX(LastEvent) AS LastEvent,
FROM
    `//home/yabs/stat/AutobudgetAuditCPM`
GROUP BY
    OrderID, AutobudgetStartTime, StartTime
;

$FinishedYesterdayAuditStats = SELECT *
FROM
    $AuditStats
WHERE
    $Today - DateTime::IntervalFromDays(1) <= $ToTimestamp(FinishTime)
    AND $ToTimestamp(FinishTime) <= $Today
;

SELECT
    $ToSeconds($Now) as RunTime,
    OrderID,
    $GetLimitType(WeekLimit, PeriodLimit) as LimitType,
    $GetLimitBudget(WeekLimit, PeriodLimit) as LimitBudget,
    $GetLimitBudget(WeekLimitCur, PeriodLimitCur) as LimitBudgetCur,

    Cost as Budget,
    CostCur as BudgetCur,

    $GetExceed($GetLimitBudget(WeekLimit, PeriodLimit), Cost) as Exceed,
    $GetExceed($GetLimitBudget(WeekLimitCur, PeriodLimitCur), CostCur) as ExceedCur,
    $GetExceedRate($GetLimitBudget(WeekLimit, PeriodLimit), Cost) as ExceedRate,
    $GetExceedRate($GetLimitBudget(WeekLimitCur, PeriodLimitCur), CostCur) as ExceedCurRate,

    AutobudgetStartTime as AutobudgetStartTime,
    StartTime as PeriodStartTime,
    FinishTime as PeriodFinishTime,
    FirstEvent,
    LastEvent
FROM
    $FinishedYesterdayAuditStats
WHERE
    (
        (NOT IsCurrency AND $GetLimitBudget(WeekLimit, PeriodLimit) > 0) OR
        (IsCurrency AND $GetLimitBudget(WeekLimitCur, PeriodLimitCur) > 0)
    ) AND (
        (NOT IsCurrency AND $GetExceedRate($GetLimitBudget(WeekLimit, PeriodLimit), Cost) > $MinExceedRate) OR
        (IsCurrency AND $GetExceedRate($GetLimitBudget(WeekLimitCur, PeriodLimitCur), CostCur) > $MinExceedRate)
    )
;

SELECT
    $ToSeconds($Now) as RunTime,
    COUNT(*) as TotalCheckedRows,
FROM
    $FinishedYesterdayAuditStats
;
'''
