# -*- coding: utf-8 -*-

import re
import tarfile
import json

import sandbox.common.types.resource as ctr
from sandbox import sdk2


def is_bstat(hostname):
    if re.match("bstat(\d{2,3})\w", hostname):
        return True
    return False


def get_base_no(bstat):
    base_no = re.match("bstat(\d{2,3})\w.*", bstat).group(1)
    return int(base_no)


def get_all_bstats():
    hosts_path = sdk2.ResourceData(
        sdk2.Resource["YABS_GLOBAL_INFO_HOSTS"].find(state=ctr.State.READY).first()
    ).path
    timestats_path = sdk2.ResourceData(
        sdk2.Resource["YABS_TIMESTATS4"].find(state=ctr.State.READY).first()
    ).path
    with tarfile.open(str(timestats_path), mode="r:gz") as timestats_archive, tarfile.open(str(hosts_path), mode="r:gz") as hosts_archive:
        timestats = json.load(timestats_archive.extractfile("timestats4.json"))
        hosts = hosts_archive.extractfile("hosts")

        bstats = {}
        for host in hosts:
            h = host.split("\t")
            hostname = h[0]
            domain = h[4]
            if is_bstat(hostname) and timestats[hostname]["HostState"] == "openstat":
                base_no = get_base_no(hostname)
                fqdn = "{hostname}.{domain}".format(
                    hostname=hostname,
                    domain=domain,
                )
                bstats[base_no] = fqdn

        return bstats
