# -*- coding: utf-8 -*-

import logging


class Diff(object):
    def __init__(self, query):
        self.has_diff = False
        self.content = {}
        self.operation_url = query.share_url

        results = query.get_results()
        self.query_succeed = results.is_success

        if not self.query_succeed:
            logging.error("Request failed")
        else:
            for table in results:
                self.add_result(table)

    def add_result(self, yql_result):
        if not yql_result.rows:
            pass
        else:
            if yql_result.label == "TablePresence":
                self.content["TablePresence"] = {}
                for table_name, present_at_testing, present_at_stable in yql_result.rows:
                    self.content["TablePresence"][table_name] = {
                        "testing": present_at_testing,
                        "stable": present_at_stable,
                    }
            else:
                self.has_diff = True
                self.content[yql_result.label] = {
                    "diff_columns": set(),
                    "diff_values": []
                }
                for row in [dict(zip(yql_result.column_names, row)) for row in yql_result.rows]:
                    row_diff = {}
                    for column in row:
                        if not column.startswith("Testing"):
                            continue
                        real_column_name = column[len("Testing."):]
                        testing_value = row["Testing." + real_column_name]
                        stable_value = row["Stable." + real_column_name]
                        row_diff[real_column_name] = {
                            "testing": testing_value,
                            "stable": stable_value,
                            "has_diff": testing_value != stable_value,
                        }
                        if row_diff[real_column_name]["has_diff"]:
                            self.content[yql_result.label]["diff_columns"].add(real_column_name)
                    self.content[yql_result.label]["diff_values"].append(row_diff)
                self.content[yql_result.label]["diff_columns"] = list(self.content[yql_result.label]["diff_columns"])
