# -*- coding: utf-8 -*-

TABLE_QUERIES = '''
use {{ cluster }};

pragma DisableSimpleColumns;

{% for table in tables %}
define action $Diff{{ table }}($testing_path, $stable_path)  as
    $testing_table = $testing_path || "/" || "{{ table }}";
    $stable_table = $stable_path || "/" || "{{ table }}";
    select *
    from $testing_table as Testing
    full join $stable_table as Stable
        using(
            {%- for column in table_schema[table]['key_columns'] %}
            {{ column }}{{ "," if not loop.last }}
            {%- endfor %}
        )
    where
        {%- for column in table_schema[table]['value_columns'] %}
        {{ "and " if not loop.first }}Testing.{{ column }} != Stable.{{ column }}
        {%- endfor %}
    into result `{{ table }}`;
end define;
export $Diff{{ table }};
{% endfor %}
'''

MAIN_QUERY = '''
use {{ cluster }};

pragma Library = "table_queries.sql";
pragma DisableSimpleColumns;

import table_queries symbols
    {%- for table in tables %}
    $Diff{{ table }}{{ "," if not loop.last }}
    {%- endfor %}
    ;

declare $testing_dir_path as String;
declare $stable_dir_path as String;

$testing_tables = (select TableName(Path, "yt") as TableName from Folder($testing_dir_path));
$stable_tables = (select TableName(Path, "yt") as TableName from Folder($stable_dir_path));
$common_tables = (
    select
        ToSet(aggregate_list(Stable.TableName))
    from $testing_tables as Testing
    join $stable_tables as Stable
        using(TableName)
);

select
    Testing.TableName ?? Stable.TableName as TableName,
    if(Testing.TableName is not null, true, false) as PresentAtTesting,
    if(Stable.TableName is not null, true, false) as PresentAtStable
from $testing_tables as Testing
full join $stable_tables as Stable
    using(TableName)
order by
    PresentAtTesting asc,
    PresentAtStable asc
into result `TablePresence`;

{% for table in tables %}
evaluate if DictContains($common_tables, "{{ table }}")
    do $Diff{{ table }}($testing_dir_path, $stable_dir_path);
{%- endfor %}
'''
