# -*- coding: utf-8 -*-

DIFF_TEMPLATE = """
<style>
td, th {
    display: table-cell;
    vertical-align: inherit;
    padding: 5px 10px;
    border: 1px solid;
    border-spacing: 2px;
}
</style>

<table style="border-spacing: 2px; border-collapse: separate;">
{% for column in table_schema['key_columns'] %}
    <th style="padding: 5px 10px; border: 1px solid; border-spacing: 2px;"> {{ column }} </th>
{% endfor %}
{% for column in diff_columns %}
    <th style="padding: 5px 10px; border: 1px solid; border-spacing: 2px; color: red;"> <b>{{ column }}</b> </th>
{% endfor %}

{% for row in diff_values %}
    <tr>
    {% for column in key_columns %}
        <td style="padding: 5px 10px; border: 1px solid; border-spacing: 2px;">{{ row[column]["stable"] }} </td>
    {% endfor %}
    {% for column in diff_columns %}
        {% if row[column]["stable"] != row[column]["testing"] %}
            <td style="padding: 5px 10px; border: 1px solid; border-spacing: 2px;"> {{ row[column]["stable"] }} / {{ row[column]["testing"] }} </td>
        {% else %}
            <td style="padding: 5px 10px; border: 1px solid; border-spacing: 2px;">{{ row[column]["stable"] }} </td>
        {% endif %}
    {% endfor %}
    </tr>
{% endfor %}
</table>
"""
