from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.sdk2.helpers import subprocess as sp


class Compressor(object):
    def __init__(self, ya=None):
        if ya is None:
            ya = sdk2.svn.Arcadia.export('arcadia:/arc/trunk/arcadia/ya', 'ya')
        self.__ya = ya

    def pack(self, source_path, destination_path, codec="zstd_1", cwd="./"):
        tar = sp.Popen(
            ["tar", "--verbose", "--directory", cwd, "--create", source_path],
            stdout=sp.PIPE,
        )
        uc = sp.Popen(
            [self.__ya, "tool", "uc", "--verbose", "--compress", "--to", destination_path, "--codec", codec],
            stdin=tar.stdout,
        )
        tar.stdout.close()
        uc_return_code = uc.wait()
        tar_return_code = tar.wait()
        if uc_return_code != 0 or tar_return_code != 0:
            raise TaskFailure("Failed to pack {source} to {destination}".format(source=source_path, destination=destination_path))

    def unpack(self, package_path, destination_path, codec="zstd_1"):
        uc = sp.Popen(
            [self.__ya, "tool", "uc", "--verbose", "--decompress", "--from", package_path, "--codec", codec],
            stdout=sp.PIPE,
        )
        tar = sp.Popen(
            ["tar", "--verbose", "--extract", "--directory", destination_path],
            stdin=uc.stdout,
        )
        uc.stdout.close()
        uc_return_code = uc.wait()
        tar_return_code = tar.wait()
        if uc_return_code != 0 or tar_return_code != 0:
            raise TaskFailure("Failed to unpack {package} to {destination}".format(package=package_path, destination=destination_path))
