import sandbox.common.types.task as ctt

from sandbox import common
from sandbox import sdk2
from sandbox.projects.autobudget.back_to_back.lib.controller import YabsOldAutobudgetBackToBackController


class YabsOldAutobudgetBackToBack(sdk2.Task):
    class Parameters(sdk2.Parameters):
        basenos = sdk2.parameters.List(
            "BaseNos to launch back to back tests for",
            sdk2.parameters.Integer,
            default=[
                11,
                127,
                130,
                138,
            ],
            required=True,
        )

    def on_execute(self):
        basenos = self.Parameters.basenos

        subtasks = []
        for baseno in basenos:
            subtask = YabsOldAutobudgetBackToBackController(
                self,
                description="Run tests for {baseno} shard".format(baseno=baseno),
                baseno=baseno,
            )
            subtasks.append(subtask)

        raise sdk2.WaitTask(
            subtasks,
            common.utils.chain(ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)
        )
