# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.yabs.base_bin_task import BaseBinTask

from sandbox.projects.autobudget.back_to_back.lib.stand import YabsOldAutobudgetBackToBackStand


class YabsAutobudgetBackToBackNoOp(BaseBinTask):
    class Parameters(BaseBinTask.Parameters):
        stand_task = sdk2.parameters.Task(
            "Stand task",
            task_type=YabsOldAutobudgetBackToBackStand,
            required=True,
        )

        with sdk2.parameters.Group("Infrastructure parameters"):
            resource_attrs = sdk2.parameters.Dict(
                "Filter resource by",
                default={"name": "autobudget-back-to-back-binary"},
                description="Will be passed to 'attrs' search parameter",
            )

    class Requirements(BaseBinTask.Requirements):
        cores = 1
        ram = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        pass
